/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portletbridge.application;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import javax.faces.FacesException;

class ByteArrayWebOutputStream
extends OutputStream {
    private DirectByteArrayOutputStream baos = new DirectByteArrayOutputStream(1024);

    public void write(int n) {
        this.baos.write(n);
    }

    public void resetByteArray() {
        this.baos.reset();
    }

    public byte[] toByteArray() {
        return this.baos.toByteArray();
    }

    public void writeTo(Writer writer, String encoding) {
        ByteBuffer bBuff = this.baos.getByteBuffer();
        CharsetDecoder decoder = Charset.forName(encoding).newDecoder();
        try {
            CharBuffer cBuff = decoder.decode(bBuff);
            writer.write(cBuff.array());
        }
        catch (CharacterCodingException cce) {
            throw new FacesException((Throwable)cce);
        }
        catch (IOException ioe) {
            throw new FacesException((Throwable)ioe);
        }
    }

    public void writeTo(OutputStream stream) {
        try {
            stream.write(this.baos.getByteBuffer().array());
        }
        catch (IOException ioe) {
            throw new FacesException((Throwable)ioe);
        }
    }

    private static class DirectByteArrayOutputStream
    extends ByteArrayOutputStream {
        public DirectByteArrayOutputStream(int initialCapacity) {
            super(initialCapacity);
        }

        public ByteBuffer getByteBuffer() {
            return ByteBuffer.wrap(this.buf, 0, this.count);
        }
    }
}

