/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.workflow.test;

import java.util.Collection;
import java.util.Random;
import junit.framework.TestCase;
import org.jbpm.JbpmConfiguration;
import org.jbpm.JbpmContext;
import org.jbpm.graph.def.ProcessDefinition;
import org.jbpm.graph.exe.ProcessInstance;
import org.jbpm.graph.exe.Token;
import org.jbpm.taskmgmt.exe.TaskInstance;

public class PortalCMSPublish
extends TestCase {
    static JbpmConfiguration jbpmConfiguration = null;
    static ProcessDefinition processDefinition = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUp() {
        jbpmConfiguration.createSchema();
        JbpmContext jbpmContext = jbpmConfiguration.createJbpmContext();
        try {
            jbpmContext.deployProcessDefinition(processDefinition);
        }
        finally {
            jbpmContext.close();
        }
    }

    protected void tearDown() throws Exception {
        jbpmConfiguration.dropSchema();
    }

    public void testCMSPublish() throws Exception {
        long processId1 = this.createTask("/default/index.html");
        long processId2 = this.createTask("/default/index2.html");
        ApprovalThread t1 = new ApprovalThread(processId1, "/default/index.html", true);
        ApprovalThread t2 = new ApprovalThread(processId2, "/default/index2.html", false);
        Thread thread1 = new Thread(t1);
        Thread thread2 = new Thread(t2);
        thread1.start();
        thread2.start();
        while (!t1.done || !t2.done) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long createTask(String path) {
        long processId = 0L;
        JbpmContext jbpmContext = jbpmConfiguration.createJbpmContext();
        ProcessInstance processInstance = null;
        try {
            processInstance = jbpmContext.newProcessInstance("approval_workflow");
            Token token = processInstance.getRootToken();
            processInstance.getContextInstance().setVariable("path", (Object)path);
            token.signal();
        }
        finally {
            if (processInstance != null) {
                jbpmContext.save(processInstance);
                processId = processInstance.getId();
            }
            jbpmContext.close();
        }
        return processId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeTask(String path, long processId, String manager, boolean reject) throws Exception {
        JbpmContext jbpmContext = jbpmConfiguration.createJbpmContext();
        ProcessInstance processInstance = null;
        try {
            processInstance = jbpmContext.loadProcessInstance(processId);
            if (processInstance.hasEnded()) {
                System.out.println("This process has already ended...");
                return;
            }
            Collection allTasks = processInstance.getTaskMgmtInstance().getTaskInstances();
            String[] transitions = new String[]{"approval", "rejection"};
            Random random = new Random(12343L);
            boolean markedForRejection = false;
            for (TaskInstance task : allTasks) {
                if (markedForRejection) {
                    task.end(transitions[1]);
                    continue;
                }
                if (!task.getActorId().equals(manager)) continue;
                System.out.println("Manager=" + task.getActorId() + "(" + processId + ")");
                int randomIndex = Math.abs(random.nextInt() % 2);
                if (randomIndex == 1) {
                    markedForRejection = true;
                    task.end(transitions[randomIndex]);
                    continue;
                }
                task.end(transitions[randomIndex]);
                break;
            }
        }
        finally {
            if (processInstance != null) {
                jbpmContext.save(processInstance);
            }
            jbpmContext.close();
        }
    }

    static {
        jbpmConfiguration = JbpmConfiguration.parseXmlString((String)"<jbpm-configuration>  <jbpm-context>    <service name='persistence'              factory='org.jbpm.persistence.db.DbPersistenceServiceFactory' />  </jbpm-context>  <string name='resource.hibernate.cfg.xml'           value='conf/hibernate.cfg.xml' />  <string name='resource.business.calendar'           value='org/jbpm/calendar/jbpm.business.calendar.properties' />  <string name='resource.default.modules'           value='org/jbpm/graph/def/jbpm.default.modules.properties' />  <string name='resource.converter'           value='org/jbpm/db/hibernate/jbpm.converter.properties' />  <string name='resource.action.types'           value='org/jbpm/graph/action/action.types.xml' />  <string name='resource.node.types'           value='org/jbpm/graph/node/node.types.xml' />  <string name='resource.varmapping'           value='org/jbpm/context/exe/jbpm.varmapping.xml' /></jbpm-configuration>");
        processDefinition = ProcessDefinition.parseXmlString((String)"<process-definition name='approval_workflow'>  <start-state>    <transition to='request_approval'/>  </start-state>  <task-node name='request_approval'>    <task name='approve_publish'>      <assignment class='org.jboss.portal.workflow.test.PublishAssignmentHandler'/>    </task>    <controller>      <variable name='path' access='read'/>\t   </controller>    <transition name='approval' to='end'/>    <transition name='rejection' to='end'>       <script name='signalRejection'>         <variable name='rejection'/>         <expression>              System.out.println(\"Running the rejection script....\");rejection=true;         </expression>       </script>    </transition>  </task-node>  <end-state name='end'>    <event type='node-enter'>       <action class='org.jboss.portal.workflow.test.Finalize'/>    </event>  </end-state></process-definition>");
    }

    private class ApprovalThread
    implements Runnable {
        long processId = 0L;
        String path = null;
        boolean reject = false;
        boolean done = false;

        private ApprovalThread(long processId, String path, boolean reject) {
            this.processId = processId;
            this.path = path;
            this.reject = reject;
        }

        public void run() {
            try {
                String[] managers = new String[]{"Admin", "eric.brown@jboss.com", "sohil.shah@jboss.com"};
                for (int i = 0; i < managers.length; ++i) {
                    PortalCMSPublish.this.executeTask(this.path, this.processId, managers[i], this.reject);
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.done = true;
            }
        }
    }
}

