/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.faces.component.portlet;

import java.util.Map;
import javax.faces.application.ViewHandler;
import javax.faces.context.FacesContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.portal.Mode;
import org.jboss.portal.WindowState;
import org.jboss.portal.common.net.media.MediaType;
import org.jboss.portal.common.text.CharBuffer;
import org.jboss.portal.common.text.CharWriter;
import org.jboss.portal.common.text.FastURLEncoder;
import org.jboss.portal.common.util.MarkupInfo;
import org.jboss.portal.faces.component.portlet.JSFPortalContext;
import org.jboss.portal.faces.component.portlet.JSFSecurityContext;
import org.jboss.portal.faces.component.portlet.JSFServerContext;
import org.jboss.portal.faces.component.portlet.JSFUserContext;
import org.jboss.portal.faces.component.portlet.JSFWindowContext;
import org.jboss.portal.faces.component.portlet.PortletRequestEncoder;
import org.jboss.portal.faces.component.portlet.UIPortlet;
import org.jboss.portal.portlet.ActionURL;
import org.jboss.portal.portlet.ContainerURL;
import org.jboss.portal.portlet.ParametersStateString;
import org.jboss.portal.portlet.Portlet;
import org.jboss.portal.portlet.PortletInvoker;
import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.RenderURL;
import org.jboss.portal.portlet.StateString;
import org.jboss.portal.portlet.URLFormat;
import org.jboss.portal.portlet.bridge.JBossServletContextProvider;
import org.jboss.portal.portlet.impl.spi.AbstractPortletInvocationContext;
import org.jboss.portal.portlet.impl.spi.AbstractRequestContext;
import org.jboss.portal.portlet.invocation.ActionInvocation;
import org.jboss.portal.portlet.invocation.PortletInvocation;
import org.jboss.portal.portlet.invocation.RenderInvocation;
import org.jboss.portal.portlet.invocation.response.PortletInvocationResponse;
import org.jboss.portal.portlet.spi.PortalContext;
import org.jboss.portal.portlet.spi.PortletInvocationContext;
import org.jboss.portal.portlet.spi.RequestContext;
import org.jboss.portal.portlet.spi.SecurityContext;
import org.jboss.portal.portlet.spi.ServerContext;
import org.jboss.portal.portlet.spi.UserContext;
import org.jboss.portal.portlet.spi.WindowContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSFInvocation {
    final HttpServletRequest clientRequest;
    final HttpServletResponse clientResponse;
    final FacesContext faces;
    final UIPortlet uiportlet;
    final PortalContext portalContext;
    final RequestContext requestContext;
    final SecurityContext securityContext;
    final UserContext userContext;
    final WindowContext windowContext;
    final ServerContext serverContext;

    public JSFInvocation(FacesContext faces, UIPortlet uiportlet) {
        JBossServletContextProvider.BridgeInfo info = JBossServletContextProvider.get();
        PortletInvocation portletInvocation = info.getInvocation();
        this.clientRequest = portletInvocation.getDispatchedRequest();
        this.clientResponse = portletInvocation.getDispatchedResponse();
        this.faces = faces;
        this.uiportlet = uiportlet;
        this.portalContext = new JSFPortalContext(faces, uiportlet);
        this.requestContext = new AbstractRequestContext(this.clientRequest);
        this.securityContext = new JSFSecurityContext(faces);
        this.windowContext = new JSFWindowContext(faces);
        this.serverContext = new JSFServerContext(this);
        this.userContext = new JSFUserContext((JSFServerContext)this.serverContext, faces);
    }

    String renderURL(ContainerURL containerURL, Boolean wantSecure, Boolean wantAuthenticated, boolean relative) {
        ViewHandler vh = this.faces.getApplication().getViewHandler();
        String viewId = this.faces.getViewRoot().getViewId();
        String clientId = this.uiportlet.getClientId(this.faces);
        String actionURL = vh.getActionURL(this.faces, viewId);
        actionURL = this.faces.getExternalContext().encodeActionURL(actionURL);
        CharBuffer url = new CharBuffer();
        url.append((CharSequence)actionURL);
        url.append((CharSequence)"&amp;").append((CharSequence)clientId).append((CharSequence)"=jbp");
        PortletRequestEncoder encoder = new PortletRequestEncoder();
        if (containerURL instanceof ActionURL) {
            ActionURL actionURL2 = (ActionURL)containerURL;
            encoder.encodeAction(null, actionURL2.getInteractionState(), actionURL2.getMode(), actionURL2.getWindowState());
        } else if (containerURL instanceof RenderURL) {
            RenderURL renderURL = (RenderURL)containerURL;
            encoder.encodeRender(renderURL.getNavigationalState(), renderURL.getMode(), renderURL.getWindowState());
        }
        for (Map.Entry entry : encoder.getQueryParameters().entrySet()) {
            String name = FastURLEncoder.getUTF8Instance().encode((String)entry.getKey());
            String[] values = (String[])entry.getValue();
            for (int j = 0; j < values.length; ++j) {
                String value = values[j];
                url.append((CharSequence)"&amp;").append((CharSequence)name).append('=');
                FastURLEncoder.getUTF8Instance().encode((CharSequence)value, (CharWriter)url);
            }
        }
        return url.asString();
    }

    public PortletInvocationResponse action(Portlet portlet, Mode mode, WindowState windowState, StateString interactionState) throws PortletInvokerException {
        JSFPortletInvocationContext portletInvocationContext = new JSFPortletInvocationContext(this.clientRequest, this.clientResponse, new MarkupInfo(MediaType.TEXT_HTML, "UTF-8"), this);
        ActionInvocation action = new ActionInvocation((PortletInvocationContext)portletInvocationContext);
        action.setInteractionState(interactionState);
        if (mode != null) {
            action.setMode(mode);
        } else {
            action.setMode(Mode.VIEW);
        }
        if (windowState != null) {
            action.setWindowState(windowState);
        } else {
            action.setWindowState(WindowState.NORMAL);
        }
        return this.invoke(portlet, (PortletInvocation)action);
    }

    public PortletInvocationResponse render(Portlet portlet, Mode mode, WindowState windowState, Map<String, String[]> navState) throws PortletInvokerException {
        JSFPortletInvocationContext portletInvocationContext = new JSFPortletInvocationContext(this.clientRequest, this.clientResponse, new MarkupInfo(MediaType.TEXT_HTML, "UTF-8"), this);
        RenderInvocation render = new RenderInvocation((PortletInvocationContext)portletInvocationContext);
        render.setNavigationalState((StateString)ParametersStateString.create(navState));
        if (mode != null) {
            render.setMode(mode);
        } else {
            render.setMode(Mode.VIEW);
        }
        if (windowState != null) {
            render.setWindowState(windowState);
        } else {
            render.setWindowState(WindowState.NORMAL);
        }
        return this.invoke(portlet, (PortletInvocation)render);
    }

    private PortletInvocationResponse invoke(Portlet portlet, PortletInvocation invocation) throws PortletInvokerException {
        invocation.setPortalContext(this.portalContext);
        invocation.setSecurityContext(this.securityContext);
        invocation.setUserContext(this.userContext);
        invocation.setServerContext(this.serverContext);
        invocation.setWindowContext(this.windowContext);
        invocation.setTarget(portlet.getContext());
        PortletInvoker invoker = this.uiportlet.getPortletInvoker();
        return invoker.invoke(invocation);
    }

    private static class JSFPortletInvocationContext
    extends AbstractPortletInvocationContext {
        private HttpServletRequest clientRequest;
        private HttpServletResponse clientResponse;
        private JSFInvocation invocation;

        public JSFPortletInvocationContext(HttpServletRequest clientRequest, HttpServletResponse clientResponse, MarkupInfo markupInfo, JSFInvocation invocation) {
            super(markupInfo);
            this.clientRequest = clientRequest;
            this.clientResponse = clientResponse;
            this.invocation = invocation;
        }

        public HttpServletRequest getClientRequest() throws IllegalStateException {
            return this.clientRequest;
        }

        public HttpServletResponse getClientResponse() throws IllegalStateException {
            return this.clientResponse;
        }

        public String renderURL(ContainerURL containerURL, URLFormat urlFormat) {
            return this.invocation.renderURL(containerURL, urlFormat.getWantSecure(), urlFormat.getWantAuthenticated(), urlFormat.getWantRelative());
        }
    }
}

