/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.common.ant;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.jboss.portal.common.ant.CannotCreateDirException;
import org.jboss.portal.common.ant.DirException;
import org.jboss.portal.common.ant.FileIsNotDirException;

public class Explode
extends Task {
    private static final Set extensions = new HashSet<String>(Arrays.asList("ear", "war", "sar", "har"));
    private File file;
    private File todir;
    private String name;
    private String exclude;

    public void setExclude(String exclude) {
        this.exclude = exclude;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setTodir(File todir) {
        this.todir = todir;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void execute() throws BuildException {
        try {
            this.explode(this.file, this.todir);
        }
        catch (DirException e) {
            throw new BuildException(e.getMessage());
        }
    }

    public void explode(File file, File todir) throws BuildException, DirException {
        if (!file.exists()) {
            throw new BuildException("source file does not exists");
        }
        if (!file.isFile()) {
            throw new BuildException("source file is not file");
        }
        if (this.name == null) {
            this.name = file.getName();
        }
        ZipInputStream zip = null;
        try {
            zip = new ZipInputStream(new BufferedInputStream(new FileInputStream(file)));
            this.log("Process archive " + this.name);
            Explode.explode(this, this.name, zip, todir, this.exclude);
        }
        catch (FileNotFoundException e) {
            throw new BuildException("Unexpected error " + e.getMessage());
        }
        finally {
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void explode(Explode explode, String name, ZipInputStream zip, File todir, String exclude) throws BuildException, DirException {
        if (!todir.exists()) {
            throw new BuildException("target dir does not exists");
        }
        if (!todir.isDirectory()) {
            throw new BuildException("target dir is not a directory");
        }
        try {
            byte[] buffer = new byte[512];
            todir = new File(todir, name);
            Explode.ensureDirExist(explode, todir);
            ZipEntry entry = zip.getNextEntry();
            while (entry != null) {
                File fic = new File(todir, entry.getName());
                int lastDot = fic.getName().lastIndexOf(".");
                if (entry.isDirectory()) {
                    try {
                        Explode.ensureDirExist(explode, fic);
                    }
                    catch (DirException e) {
                        explode.log(e.getMessage());
                    }
                } else if (lastDot != -1 && extensions.contains(fic.getName().substring(lastDot + 1))) {
                    try {
                        explode.log("Process nested archive " + fic.getName());
                        if (!fic.getName().equalsIgnoreCase(exclude)) {
                            Explode.explode(explode, fic.getName(), new ZipInputStream(zip), todir, exclude);
                        }
                    }
                    catch (DirException e) {
                        explode.log(e.getMessage());
                    }
                } else {
                    OutputStream out = null;
                    try {
                        out = new BufferedOutputStream(new FileOutputStream(fic));
                        int size = zip.read(buffer);
                        while (size != -1) {
                            out.write(buffer, 0, size);
                            size = zip.read(buffer);
                        }
                    }
                    catch (IOException e) {
                        explode.log("Problem when writing file " + e.getMessage());
                    }
                    finally {
                        if (out != null) {
                            try {
                                out.close();
                            }
                            catch (IOException ignored) {}
                        }
                    }
                }
                entry = zip.getNextEntry();
            }
        }
        catch (ZipException e) {
            throw new BuildException((Throwable)e);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private static void ensureDirExist(Explode explode, File dir) throws FileIsNotDirException, CannotCreateDirException {
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new FileIsNotDirException(dir);
            }
        } else if (!dir.mkdirs()) {
            throw new CannotCreateDirException(dir);
        }
    }
}

