/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.common.text;

import org.jboss.portal.common.text.AbstractCharEncoder;
import org.jboss.portal.common.text.CharToByteEncoder;
import org.jboss.portal.common.text.CharWriter;
import org.jboss.portal.common.text.MalformedInputException;
import org.jboss.portal.common.text.TextTools;

public class FastURLDecoder
extends AbstractCharEncoder {
    private static final FastURLDecoder UTF8 = new FastURLDecoder(CharToByteEncoder.Generic.UTF8);
    private static final FastURLDecoder UTF8_STRICT = new FastURLDecoder(CharToByteEncoder.Generic.UTF8, true);
    private static final char FROM = '\u0000';
    private static final char TO = '\ufffd';
    private static final int AS_IS = 0;
    private static final int PLUS = 1;
    private static final int ESCAPE = 2;
    private static final int ERROR = 3;
    private final LookupNonTerm root;
    private final int[] decisions;
    private final int[][] conversions;
    private final boolean strict;

    public static FastURLDecoder getUTF8Instance() {
        return UTF8;
    }

    public static FastURLDecoder getUTF8StrictInstance() {
        return UTF8_STRICT;
    }

    public FastURLDecoder(CharToByteEncoder encoder) {
        this(encoder, false);
    }

    public FastURLDecoder(CharToByteEncoder encoder, boolean strict) {
        int i;
        this.strict = strict;
        this.root = new LookupNonTerm();
        for (char c = '\u0000'; c <= '\ufffd'; c = (char)(c + '\u0001')) {
            byte[] v = encoder.encode(c);
            LookupNonTerm node = this.root;
            int k = v.length;
            for (int i2 = 0; i2 < k; ++i2) {
                int index = v[i2] & 0xFF;
                if (i2 == k - 1) {
                    ((LookupNonTerm)node).children[index] = new LookupTerm(c);
                    continue;
                }
                if (node.children[index] == null) {
                    ((LookupNonTerm)node).children[index] = new LookupNonTerm();
                }
                node = (LookupNonTerm)node.children[index];
            }
        }
        this.conversions = new int[256][256];
        for (i = 0; i < 256; i = (int)((char)(i + '\u0001'))) {
            int x = FastURLDecoder.hexValue((char)i);
            for (char j = '\u0000'; j < '\u0100'; j = (char)(j + '\u0001')) {
                int y = FastURLDecoder.hexValue(j);
                this.conversions[i][j] = x != -1 && y != -1 ? (x << 4) + y : -1;
            }
        }
        this.decisions = new int[256];
        block9: for (i = 0; i < this.decisions.length; ++i) {
            if (TextTools.isAlphaNumeric((char)i)) {
                this.decisions[i] = 0;
                continue;
            }
            switch (i) {
                case 43: {
                    this.decisions[i] = 1;
                    continue block9;
                }
                case 42: 
                case 45: 
                case 46: 
                case 95: {
                    this.decisions[i] = 0;
                    continue block9;
                }
                case 37: {
                    this.decisions[i] = 2;
                    continue block9;
                }
                default: {
                    this.decisions[i] = 3;
                }
            }
        }
    }

    protected void safeEncode(char[] chars, int i, int length, CharWriter tmp) {
        while (i < length) {
            char c;
            int decision = (c = chars[i++]) < '\u0100' ? this.decisions[c] : 3;
            block0 : switch (decision) {
                case 0: {
                    tmp.append(c);
                    break;
                }
                case 1: {
                    tmp.append(' ');
                    break;
                }
                case 2: {
                    int j = i;
                    LookupNonTerm current = this.root;
                    while (true) {
                        if (j + 2 > length) {
                            throw new MalformedInputException("Not enough chars to decode an escaped value length should have been" + (j + 2) + " but is " + length);
                        }
                        char c1 = chars[j++];
                        char c2 = chars[j++];
                        if (c1 > '\u00ff') {
                            throw new MalformedInputException("Input out of the lookup range (" + c1 + "," + c2 + ")");
                        }
                        if (c2 > '\u00ff') {
                            throw new MalformedInputException("Input out of the lookup range (" + c1 + "," + c2 + ")");
                        }
                        int z = this.conversions[c1][c2];
                        if (z == -1) {
                            throw new MalformedInputException("Input out of the lookup range (" + c1 + "," + c2 + ")");
                        }
                        LookupNode child = current.children[z];
                        if (child instanceof LookupTerm) {
                            LookupTerm term = (LookupTerm)child;
                            tmp.append(term.c);
                            i = j;
                            break block0;
                        }
                        current = (LookupNonTerm)child;
                        ++j;
                    }
                }
                case 3: {
                    if (this.strict) {
                        throw new MalformedInputException("Cannot decode char '" + c + "'");
                    }
                    tmp.append(c);
                }
            }
        }
    }

    public boolean isStrict() {
        return this.strict;
    }

    private static int hexValue(char c) {
        if (c >= 'A' && c <= 'F') {
            return c - 65 + 10;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 97 + 10;
        }
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        return -1;
    }

    private static class LookupNonTerm
    extends LookupNode {
        private final LookupNode[] children = new LookupNode[256];

        private LookupNonTerm() {
        }
    }

    private static class LookupTerm
    extends LookupNode {
        private final char c;

        public LookupTerm(char c) {
            this.c = c;
        }
    }

    private static class LookupNode {
        private LookupNode() {
        }
    }
}

