/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.security;

import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import javax.security.auth.Subject;
import org.apache.log4j.Logger;
import org.jboss.portal.security.PortalPermission;
import org.jboss.portal.security.spi.provider.AuthorizationDomain;
import org.jboss.portal.security.spi.provider.PermissionRepository;

public abstract class PortalPermissionCollection
extends PermissionCollection {
    private static final Logger log = Logger.getLogger(PortalPermissionCollection.class);
    private AuthorizationDomain domain;
    PortalPermission owner;

    public PortalPermissionCollection(AuthorizationDomain repository) throws IllegalArgumentException {
        if (repository == null) {
            throw new IllegalArgumentException("Need a repository");
        }
        this.domain = repository;
    }

    public final void add(Permission permission) throws IllegalArgumentException {
    }

    public boolean implies(Permission permission) {
        if (permission instanceof PortalPermission) {
            try {
                PortalPermission portalPermission = (PortalPermission)permission;
                Subject caller = this.getCheckedSubject();
                String roleName = this.getRoleName();
                PermissionRepository repository = this.domain.getPermissionRepository();
                boolean implied = this.owner.implies(repository, caller, roleName, portalPermission);
                return implied;
            }
            catch (Exception e) {
                log.error((Object)"Permission check against the repository failed", (Throwable)e);
            }
        }
        return false;
    }

    public abstract Enumeration elements();

    public abstract String getRoleName();

    public abstract Subject getCheckedSubject();
}

