/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.security.impl.jacc;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;

public class JACCPortalPrincipal
implements Principal {
    private Principal[] principals;
    private Set roles = Collections.EMPTY_SET;

    public JACCPortalPrincipal(Subject subject) {
        ArrayList<Principal> principals = new ArrayList<Principal>();
        for (Principal principal : subject.getPrincipals()) {
            if (principal instanceof Group) {
                Group group = (Group)principal;
                Enumeration e = group.members();
                while (e.hasMoreElements()) {
                    Principal nestedPrincipal = (Principal)e.nextElement();
                    principals.add(nestedPrincipal);
                }
                if (!"Roles".equals(group.getName())) continue;
                this.roles = new HashSet();
                e = group.members();
                while (e.hasMoreElements()) {
                    Principal role = (Principal)e.nextElement();
                    this.roles.add(role);
                }
                continue;
            }
            principals.add(principal);
        }
        this.principals = principals.toArray(new Principal[principals.size()]);
    }

    public Set getRoles() {
        return this.roles;
    }

    public Principal[] getPrincipals() {
        return this.principals;
    }

    public String getName() {
        return "PortalPrincipal";
    }
}

