/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.security.impl.jacc;

import java.security.Permission;
import java.security.Principal;
import java.security.ProtectionDomain;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import org.jboss.portal.security.impl.jacc.Permissions;

public class SecurityContext {
    private Permissions uncheckedPermissions = new Permissions();
    private HashMap rolePermissions = new HashMap();

    SecurityContext() {
    }

    void addToRole(String roleName, Permission permission) {
        Permissions perms = (Permissions)this.rolePermissions.get(roleName);
        if (perms == null) {
            perms = new Permissions();
            this.rolePermissions.put(roleName, perms);
        }
        perms.add(permission);
    }

    void addToUncheckedPolicy(Permission permission) {
        this.uncheckedPermissions.add(permission);
    }

    boolean implies(ProtectionDomain domain, Permission permission) {
        int n;
        boolean implied = false;
        if (this.uncheckedPermissions.implies(permission)) {
            return true;
        }
        Principal[] principals = domain.getPrincipals();
        int length = principals != null ? principals.length : 0;
        ArrayList<String> princpalNames = new ArrayList<String>();
        for (n = 0; n < length; ++n) {
            Principal p = principals[n];
            if (p instanceof Group) {
                Group g = (Group)p;
                Enumeration iter = g.members();
                while (iter.hasMoreElements()) {
                    p = (Principal)iter.nextElement();
                    String name = p.getName();
                    princpalNames.add(name);
                }
                continue;
            }
            String name = p.getName();
            princpalNames.add(name);
        }
        if (princpalNames.size() > 0) {
            for (n = 0; !implied && n < princpalNames.size(); ++n) {
                String name = (String)princpalNames.get(n);
                Permissions perms = (Permissions)this.rolePermissions.get(name);
                if (perms == null) continue;
                implied = perms.implies(permission);
            }
        }
        return implied;
    }
}

