/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.admin.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jboss.portal.core.admin.ui.PreferenceBean;
import org.jboss.portal.portlet.info.PreferenceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PreferencesBean {
    List entries = new ArrayList();
    int selectedIndex = -1;
    private boolean mutable;

    public PreferencesBean(boolean mutable) {
        this.mutable = mutable;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void setSelectedIndex(int selectedIndex) {
        if (selectedIndex < 0 || selectedIndex >= this.entries.size()) {
            throw new IllegalArgumentException();
        }
        this.selectedIndex = selectedIndex;
    }

    public void unselectEntry() {
        this.selectedIndex = -1;
    }

    public PreferenceBean getSelectedEntry() {
        if (this.selectedIndex < 0 || this.selectedIndex >= this.entries.size()) {
            return null;
        }
        return (PreferenceBean)this.entries.get(this.selectedIndex);
    }

    public void addEntry(PreferenceInfo prefInfo) {
        if (this.mutable) {
            throw new IllegalStateException("Cannot add non mutable entry to a mutable preferences bean");
        }
        this.addEntry(new PreferenceBean(prefInfo, null));
    }

    public void addEntry(PreferenceInfo prefInfo, List<String> value) {
        if (!this.mutable) {
            throw new IllegalStateException("Cannot add mutable entry to a non mutable preferences bean");
        }
        this.addEntry(new PreferenceBean(prefInfo, value));
    }

    private void addEntry(PreferenceBean pref) {
        if (pref.container != null) {
            throw new IllegalStateException("Already contained somewhere");
        }
        pref.container = this;
        this.entries.add(pref);
        Collections.sort(this.entries);
    }

    public List getEntries() {
        return Collections.unmodifiableList(this.entries);
    }

    public int getSize() {
        return this.entries.size();
    }
}

