/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.admin.ui.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ActionEvent;
import javax.faces.model.SelectItem;
import javax.xml.namespace.QName;
import org.jboss.portal.Mode;
import org.jboss.portal.api.content.SelectedContent;
import org.jboss.portal.core.admin.ui.actions.WindowComparator;
import org.jboss.portal.core.impl.model.content.ContentProviderRegistryService;
import org.jboss.portal.core.model.content.Content;
import org.jboss.portal.core.model.content.ContentType;
import org.jboss.portal.core.model.content.spi.ContentProvider;
import org.jboss.portal.core.model.content.spi.portlet.ContentPortlet;
import org.jboss.portal.core.model.portal.DuplicatePortalObjectException;
import org.jboss.portal.core.model.portal.NoSuchPortalObjectException;
import org.jboss.portal.core.model.portal.Page;
import org.jboss.portal.core.model.portal.PortalObject;
import org.jboss.portal.core.model.portal.Window;
import org.jboss.portal.faces.component.portlet.PortletEventEvent;
import org.jboss.portal.faces.component.portlet.PortletRenderEvent;
import org.jboss.portal.faces.el.PropertyValue;
import org.jboss.portal.faces.el.dynamic.DynamicBean;
import org.jboss.portal.faces.gui.ManagedBean;
import org.jboss.portal.portlet.PortletInvoker;
import org.jboss.portal.portlet.invocation.response.UpdateNavigationalStateResponse;
import org.jboss.portal.theme.LayoutService;
import org.jboss.portal.theme.PortalLayout;

public class PageManagerBean
extends ManagedBean {
    private static final QName CONTENT_SELECT = new QName("urn:jboss:portal:content", "select");
    private static final int MOVE_UP = 117;
    private static final int MOVE_DOWN = 100;
    private static final int MOVE_LEFT = 108;
    private static final int ADD_ACTION = 97;
    public final LayoutService layoutService;
    public final PortletInvoker portletInvoker;
    public Page page;
    private ContentType selectedContentType;
    public DynamicMap assignedWindows = new DynamicMap();
    public String selectedContentURI;
    private Map<String, String> selectedContentParameters;
    public Map selectedRenderParameters;
    UIInput windowName = null;

    public PageManagerBean(LayoutService layoutService, PortletInvoker portletInvoker) {
        this.layoutService = layoutService;
        this.portletInvoker = portletInvoker;
        this.selectedContentType = ContentType.PORTLET;
        this.selectedRenderParameters = new HashMap();
    }

    public UIInput getWindowName() {
        return this.windowName;
    }

    public void setWindowName(UIInput windowName) {
        this.windowName = windowName;
    }

    public String getNamespace() {
        return this.windowName.getClientId(FacesContext.getCurrentInstance());
    }

    public List getContentTypeItems() {
        LinkedList<SelectItem> types = new LinkedList<SelectItem>();
        for (Object o : ContentProviderRegistryService.getInstance().getContentTypes()) {
            ContentType contentType = (ContentType)o;
            SelectItem item = new SelectItem();
            item.setValue((Object)contentType);
            item.setLabel(contentType.toString());
            if (contentType.equals((Object)ContentType.PORTLET)) {
                types.addFirst(item);
                continue;
            }
            types.addLast(item);
        }
        return types;
    }

    public ContentType getSelectedContentType() {
        return this.selectedContentType;
    }

    public void setSelectedContentType(ContentType selectedContentType) {
        this.selectedContentType = selectedContentType;
        this.selectedContentURI = null;
        this.selectedContentParameters = null;
        this.selectedRenderParameters = new HashMap();
    }

    public String getSelectedEditorPortletId() {
        if (this.selectedContentType != null) {
            return ContentProviderRegistryService.getInstance().getContentProvider(this.selectedContentType).getPortletInfo().getPortletName(ContentPortlet.EDIT_CONTENT_MODE);
        }
        return null;
    }

    protected String createWindowName(String contentType, String contentURI, boolean appendNumber) {
        String windowName;
        ContentProvider contentProvider = ContentProviderRegistryService.getInstance().getContentProvider(ContentType.create((String)contentType));
        String instanceName = contentProvider.getPortletInfo().getPortletName(Mode.VIEW);
        if (instanceName == null) {
            windowName = contentURI;
        } else {
            appendNumber = true;
            windowName = instanceName;
        }
        windowName = windowName.indexOf("Instance") != -1 ? windowName.replace("Instance", "Window") : windowName + "Window";
        if (appendNumber) {
            return windowName + "_" + (int)(100.0 * Math.random());
        }
        return windowName;
    }

    public void assignWindows(ActionEvent event) {
        String id = event.getComponent().getId();
        char direction = id.charAt(0);
        String regionName = id.substring(2);
        List selectedWindows = (List)this.assignedWindows.values.get(regionName);
        Collection children = this.page.getChildren(8);
        if (children != null) {
            Window window;
            ArrayList<Window> windows = new ArrayList<Window>(children.size());
            for (PortalObject o : children) {
                Window window2 = (Window)o;
                if (!regionName.equals(window2.getProperty("theme.region"))) continue;
                windows.add(window2);
            }
            Collections.sort(windows, new WindowComparator());
            if (direction == 'u' || direction == 'd') {
                int step;
                int index = direction == 'u' ? 1 : windows.size() - 2;
                int length = windows.size() - 1;
                int n = step = direction == 'u' ? 1 : -1;
                while (length-- > 0) {
                    window = (Window)windows.get(index);
                    if (selectedWindows.contains(window.getName())) {
                        Collections.swap(windows, index - step, index);
                    }
                    index += step;
                }
            } else if (direction == 'a') {
                if (this.selectedContentURI != null) {
                    String selectedContentURI = this.selectedContentURI;
                    Map<String, String> selectedContentParams = this.selectedContentParameters;
                    this.selectedContentURI = null;
                    this.selectedContentParameters = null;
                    this.selectedRenderParameters = new HashMap();
                    String windowName = (String)this.normalizeStringIfNeeded(this.beanContext.getParameter("blah"));
                    if (windowName == null) {
                        windowName = this.createWindowName(this.selectedContentType.toString(), selectedContentURI, false);
                        while (this.page.getWindow(windowName) != null) {
                            windowName = this.createWindowName(this.selectedContentType.toString(), selectedContentURI, true);
                        }
                    } else if ((windowName = this.checkNameValidity(windowName, "windowForm:windowName")) == null) {
                        throw new AbortProcessingException("Duplicate window name!");
                    }
                    try {
                        window = this.page.createWindow(windowName, this.selectedContentType, selectedContentURI);
                        Content content = window.getContent();
                        if (selectedContentParams != null) {
                            Iterator<Map.Entry<String, String>> i$ = selectedContentParams.entrySet().iterator();
                            while (i$.hasNext()) {
                                Map.Entry<String, String> o;
                                Map.Entry<String, String> entry = o = i$.next();
                                String paramName = entry.getKey();
                                String paramValue = entry.getValue();
                                content.setParameter(paramName, paramValue);
                            }
                        }
                        window.setDeclaredProperty("theme.region", regionName);
                        window.setDeclaredProperty("theme.order", "2147483647");
                        Collections.sort(windows, new WindowComparator());
                        windows.add(window);
                        for (int i = 0; i < windows.size(); ++i) {
                            Window tmp = (Window)windows.get(i);
                            tmp.setDeclaredProperty("theme.order", "" + i);
                        }
                        this.windowName.setValue((Object)"");
                    }
                    catch (DuplicatePortalObjectException unexpected) {
                        unexpected.printStackTrace();
                    }
                } else {
                    this.beanContext.createTargetedErrorMessage("layoutForm", "COMMON_NO_SELECTED_CONTENT", new Object[0]);
                }
            } else if (direction == 'l') {
                Iterator i = windows.iterator();
                while (i.hasNext()) {
                    Window window3 = (Window)i.next();
                    if (!selectedWindows.contains(window3.getName())) continue;
                    i.remove();
                    try {
                        this.page.destroyChild(window3.getName());
                    }
                    catch (NoSuchPortalObjectException ignore) {
                        ignore.printStackTrace();
                    }
                }
            }
            for (int i = 0; i < windows.size(); ++i) {
                Window window4 = (Window)windows.get(i);
                window4.setDeclaredProperty("theme.order", "" + i);
            }
        }
        this.assignedWindows.values.clear();
    }

    public void assignWindow(ActionEvent event) {
        PortletEventEvent eventEvent;
        UpdateNavigationalStateResponse.Event portletEvent;
        QName name;
        if (event instanceof PortletRenderEvent) {
            PortletRenderEvent renderEvent = (PortletRenderEvent)event;
            Map renderParams = renderEvent.getParameterMap();
            String[] windowNames = (String[])renderParams.get("windowName");
            if (windowNames != null && windowNames.length > 0) {
                this.windowName.setValue((Object)windowNames[0]);
            }
        } else if (event instanceof PortletEventEvent && CONTENT_SELECT.equals(name = (portletEvent = (eventEvent = (PortletEventEvent)event).getEvent()).getName())) {
            if (portletEvent.getPayload() instanceof String) {
                String uri;
                this.selectedContentURI = uri = (String)((Object)portletEvent.getPayload());
                this.selectedContentParameters = null;
            } else if (portletEvent.getPayload() instanceof SelectedContent) {
                SelectedContent selectedContent = (SelectedContent)portletEvent.getPayload();
                this.selectedContentURI = selectedContent.getUri();
                this.selectedContentParameters = selectedContent.getParameters();
            }
        }
    }

    public List getRegionNames() {
        try {
            Map windows = this.getWindows(this.page);
            ArrayList regions = new ArrayList(windows.keySet());
            regions.remove("unknown");
            Collections.sort(regions);
            return regions;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.EMPTY_LIST;
        }
    }

    public List getRegionItems() {
        try {
            Map windows = this.getWindows(this.page);
            windows.remove("unknown");
            ArrayList regions = new ArrayList(windows.keySet());
            Collections.sort(regions);
            for (int i = 0; i < regions.size(); ++i) {
                String regionName = (String)regions.get(i);
                SelectItem regionItem = new SelectItem((Object)regionName, regionName);
                regions.set(i, regionItem);
            }
            return regions;
        }
        catch (Exception e) {
            e.printStackTrace();
            return Collections.EMPTY_LIST;
        }
    }

    public Map getWindowItemsMap() throws Exception {
        Map windowMap = this.getWindows(this.page);
        for (Map.Entry entry : windowMap.entrySet()) {
            SortedSet windows = (SortedSet)entry.getValue();
            ArrayList<SelectItem> windowItems = new ArrayList<SelectItem>(windows.size());
            for (Window window : windows) {
                SelectItem windowItem = new SelectItem();
                windowItem.setValue((Object)window.getName());
                windowItem.setLabel(window.getName());
                windowItems.add(windowItem);
            }
            entry.setValue(windowItems);
        }
        return windowMap;
    }

    private Map getWindows(Page page) throws Exception {
        String layoutId = page.getProperty("layout.id");
        PortalLayout layout = this.layoutService.getLayout(layoutId, true);
        LinkedHashMap<String, TreeSet<Window>> windows = new LinkedHashMap<String, TreeSet<Window>>();
        for (String region : layout.getLayoutInfo().getRegionNames()) {
            windows.put(region, new TreeSet<Window>(new WindowComparator()));
        }
        windows.put("unknown", new TreeSet<Window>(new WindowComparator()));
        for (PortalObject window : page.getChildren(8)) {
            String region = window.getProperty("theme.region");
            if (!windows.containsKey(region)) {
                region = "unknown";
            }
            SortedSet set = (SortedSet)windows.get(region);
            set.add(window);
        }
        return windows;
    }

    protected String getObjectTypeName() {
        return "WINDOW_TYPE";
    }

    public boolean isAlreadyExisting(String objectName) {
        return this.page.getWindow(objectName) != null;
    }

    public static class DynamicMap
    implements DynamicBean {
        private Map values = new HashMap();

        public Class getType(Object propertyName) throws IllegalArgumentException {
            return List.class;
        }

        public PropertyValue getValue(Object propertyName) throws IllegalArgumentException {
            ArrayList list = (ArrayList)this.values.get(propertyName);
            if (list == null) {
                list = new ArrayList();
                this.values.put(propertyName, list);
            }
            return new PropertyValue(list);
        }

        public boolean setValue(Object propertyName, Object value) throws IllegalArgumentException {
            this.values.put(propertyName, value);
            return true;
        }
    }
}

