/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.admin.ui.portlet;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.portal.common.invocation.InvocationException;
import org.jboss.portal.core.model.instance.Instance;
import org.jboss.portal.core.model.instance.InstanceContainer;
import org.jboss.portal.core.model.instance.InstanceDefinition;
import org.jboss.portal.portlet.NoSuchPortletException;
import org.jboss.portal.portlet.Portlet;
import org.jboss.portal.portlet.PortletContext;
import org.jboss.portal.portlet.PortletInvoker;
import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.info.PortletInfo;
import org.jboss.portal.portlet.invocation.PortletInvocation;
import org.jboss.portal.portlet.invocation.response.PortletInvocationResponse;
import org.jboss.portal.portlet.state.PropertyChange;
import org.jboss.portal.portlet.state.PropertyMap;

public class PortletDefinitionInvoker
implements PortletInvoker {
    private InstanceContainer instanceContainer;

    public PortletDefinitionInvoker(InstanceContainer instanceContainer) {
        if (instanceContainer == null) {
            throw new IllegalArgumentException();
        }
        this.instanceContainer = instanceContainer;
    }

    public Set getPortlets() throws PortletInvokerException {
        Collection defs = this.instanceContainer.getDefinitions();
        HashSet<PortletDefinition> portlets = new HashSet<PortletDefinition>(defs.size());
        for (Instance instance : defs) {
            portlets.add(new PortletDefinition(instance));
        }
        return portlets;
    }

    public Portlet getPortlet(PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException {
        if (portletContext == null) {
            throw new IllegalArgumentException();
        }
        String instanceId = portletContext.getId();
        InstanceDefinition instance = this.instanceContainer.getDefinition(instanceId);
        if (instance == null) {
            throw new NoSuchPortletException(instanceId);
        }
        return new PortletDefinition((Instance)instance);
    }

    public PortletInvocationResponse invoke(PortletInvocation invocation) throws IllegalArgumentException, PortletInvokerException {
        if (invocation == null) {
            throw new IllegalArgumentException();
        }
        PortletContext portletContext = invocation.getTarget();
        if (portletContext == null) {
            throw new InvocationException("No portlet context provided");
        }
        String instanceId = portletContext.getId();
        InstanceDefinition instance = this.instanceContainer.getDefinition(instanceId);
        if (instance == null) {
            throw new NoSuchPortletException(instanceId);
        }
        return instance.invoke(invocation);
    }

    public PortletContext createClone(PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public List destroyClones(List portletContexts) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public PropertyMap getProperties(PortletContext portletContext, Set keys) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public PropertyMap getProperties(PortletContext portletContext) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public PortletContext setProperties(PortletContext portletContext, PropertyChange[] changes) throws IllegalArgumentException, PortletInvokerException, UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    private static final class PortletDefinition
    implements Portlet {
        private final PortletContext ctx;
        private final PortletInfo info;
        private final boolean remote;

        public PortletDefinition(Instance instance) throws PortletInvokerException {
            this.ctx = PortletContext.createPortletContext((String)instance.getId());
            this.info = instance.getPortlet().getInfo();
            this.remote = instance.getPortlet().isRemote();
        }

        public PortletContext getContext() {
            return this.ctx;
        }

        public PortletInfo getInfo() {
            return this.info;
        }

        public boolean isRemote() {
            return this.remote;
        }
    }
}

