/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.core.identity;

import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.Role;
import org.jboss.portal.identity.User;
import org.jboss.portal.identity.ldap.LDAPStaticGroupMembershipModuleImpl;

public abstract class AbstractLDAPGroupMembership
extends LDAPStaticGroupMembershipModuleImpl {
    public Set<Role> getRoles(User user) throws IdentityException {
        Set<Role> roles = this.searchRolesFromLDAP(user);
        String virtualAdminRoleName = System.getProperty("osivia.ldap.defaultAdminRole");
        if (StringUtils.isNotBlank((String)virtualAdminRoleName)) {
            Role virtualAdminRole = null;
            Role adminRole = null;
            for (Role role : roles) {
                if ("Administrators".equals(role.getName())) {
                    adminRole = role;
                }
                if (!virtualAdminRoleName.equals(role.getName())) continue;
                virtualAdminRole = role;
            }
            if (virtualAdminRole != null) {
                if (adminRole == null) {
                    roles.add(this.getRoleModule().findRoleByName("Administrators"));
                }
            } else if (adminRole != null) {
                roles.remove(adminRole);
            }
        }
        return roles;
    }

    protected abstract Set<Role> searchRolesFromLDAP(User var1) throws IdentityException;
}

