/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.portal.core.identity;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.InitialContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.logging.Logger;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.MembershipModule;
import org.jboss.portal.identity.RoleModule;
import org.jboss.portal.identity.UserModule;
import org.jboss.portal.identity.UserProfileModule;
import org.jboss.portal.identity.auth.UserPrincipal;
import org.jboss.security.auth.spi.LdapLoginModule;

public class NoProfilLDAPLoginModule
extends LdapLoginModule {
    private static final Logger log = Logger.getLogger(NoProfilLDAPLoginModule.class);
    protected String userModuleJNDIName;
    protected String roleModuleJNDIName;
    protected String membershipModuleJNDIName;
    protected String userProfileModuleJNDIName;
    protected String sProfils;
    private UserModule userModule;
    private RoleModule roleModule;
    private MembershipModule membershipModule;
    private UserProfileModule userProfileModule;
    private List<String> profils;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.userModuleJNDIName = (String)options.get("userModuleJNDIName");
        this.roleModuleJNDIName = (String)options.get("roleModuleJNDIName");
        this.membershipModuleJNDIName = (String)options.get("membershipModuleJNDIName");
        this.userProfileModuleJNDIName = (String)options.get("userProfileModuleJNDIName");
        this.sProfils = (String)options.get("profils");
    }

    protected UserModule getUserModule() throws Exception {
        if (this.userModule == null) {
            this.userModule = (UserModule)new InitialContext().lookup(this.userModuleJNDIName);
        }
        if (this.userModule == null) {
            throw new IdentityException("Cannot obtain UserModule using JNDI name:" + this.userModuleJNDIName);
        }
        return this.userModule;
    }

    protected RoleModule getRoleModule() throws Exception {
        if (this.roleModule == null) {
            this.roleModule = (RoleModule)new InitialContext().lookup(this.roleModuleJNDIName);
        }
        if (this.roleModule == null) {
            throw new IdentityException("Cannot obtain RoleModule using JNDI name:" + this.roleModuleJNDIName);
        }
        return this.roleModule;
    }

    protected MembershipModule getMembershipModule() throws Exception {
        if (this.membershipModule == null) {
            this.membershipModule = (MembershipModule)new InitialContext().lookup(this.membershipModuleJNDIName);
        }
        if (this.membershipModule == null) {
            throw new IdentityException("Cannot obtain MembershipModule using JNDI name:" + this.membershipModuleJNDIName);
        }
        return this.membershipModule;
    }

    protected UserProfileModule getUserProfileModule() throws Exception {
        if (this.userProfileModule == null) {
            this.userProfileModule = (UserProfileModule)new InitialContext().lookup(this.userProfileModuleJNDIName);
        }
        if (this.userProfileModule == null) {
            throw new IdentityException("Cannot obtain UserProfileModule using JNDI name:" + this.userProfileModuleJNDIName);
        }
        return this.userProfileModule;
    }

    protected List<String> getProfils() {
        if (this.profils == null) {
            this.profils = Arrays.asList(this.sProfils.split("\\|"));
            if (this.profils.size() == 1 && "unknown".equals(this.profils.get(0))) {
                this.profils = new ArrayList<String>();
            }
        }
        return this.profils;
    }

    protected boolean validatePassword(String inputPassword, String string1) {
        return true;
    }

    protected Group[] getRoleSets() throws LoginException {
        Set<Principal> principals = this.subject.getPrincipals();
        Group[] destinationRolesGroup = super.getRoleSets();
        if (this.getProfils().size() > 0) {
            try {
                for (Principal o : principals) {
                    Principal role;
                    Group group;
                    if (!(o instanceof Group) || !(group = (Group)o).getName().equals("Roles")) continue;
                    boolean profilAffecte = false;
                    for (String profil : this.getProfils()) {
                        role = this.createIdentity(profil);
                        if (!group.isMember(role)) continue;
                        profilAffecte = true;
                    }
                    if (profilAffecte) continue;
                    for (int i = 0; i < destinationRolesGroup.length; ++i) {
                        Group destinationGroup = destinationRolesGroup[i];
                        if (!destinationGroup.getName().equals("Roles") || destinationGroup.isMember(role = this.createIdentity("role-aucun-profil"))) continue;
                        destinationGroup.addMember(role);
                    }
                }
            }
            catch (Exception e) {
                log.error((Object)"Error when adding additional role: ", (Throwable)e);
            }
        }
        return destinationRolesGroup;
    }

    protected Principal createIdentity(String rolename) throws Exception {
        return new UserPrincipal(rolename);
    }
}

