/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.identity.ui.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.faces.model.SelectItem;
import org.jboss.portal.core.identity.ui.UIRole;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.MembershipModule;
import org.jboss.portal.identity.NoSuchUserException;
import org.jboss.portal.identity.Role;
import org.jboss.portal.identity.RoleModule;
import org.jboss.portal.identity.User;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityRoleBean {
    private RoleModule roleModule;
    private MembershipModule membershipModule;

    public RoleModule getRoleModule() {
        return this.roleModule;
    }

    public void setRoleModule(RoleModule roleModule) {
        this.roleModule = roleModule;
    }

    public MembershipModule getMembershipModule() {
        return this.membershipModule;
    }

    public void setMembershipModule(MembershipModule membershipModule) {
        this.membershipModule = membershipModule;
    }

    public void assignRoles(User user, List<String> roles) throws IllegalArgumentException, IdentityException {
        Set<Role> roleSet = this.checkRoles(roles);
        this.membershipModule.assignRoles(user, roleSet);
    }

    private Set<Role> checkRoles(List<String> roles) throws IllegalArgumentException, IdentityException {
        HashSet<Role> roleSet = new HashSet<Role>();
        if (roles != null && roles.size() > 0) {
            for (String roleName : roles) {
                Role role = this.roleModule.findRoleByName(roleName);
                if (role == null) continue;
                roleSet.add(role);
            }
        }
        return roleSet;
    }

    public void updateRoleDisplayName(String roleName, String roleDisplayName) throws IllegalArgumentException, IdentityException {
        Role cRole = this.roleModule.findRoleByName(roleName);
        cRole.setDisplayName(roleDisplayName);
    }

    public void updateRoles(User user, List<String> roles) throws IllegalArgumentException, NoSuchUserException, IdentityException {
        Set<Role> roleSet = this.checkRoles(roles);
        this.membershipModule.assignRoles(user, roleSet);
    }

    public UIRole getUIRole(String roleName) throws IllegalArgumentException, IdentityException {
        UIRole uiRole = new UIRole();
        Role role = this.roleModule.findRoleByName(roleName);
        uiRole.setDisplayName(role.getDisplayName());
        uiRole.setName(role.getName());
        return uiRole;
    }

    public List<SelectItem> getRoleSelectItems() {
        ArrayList<SelectItem> list = new ArrayList<SelectItem>();
        Set set = new HashSet();
        try {
            set = this.roleModule.findRoles();
        }
        catch (IdentityException e) {
            e.printStackTrace();
        }
        for (Role role : set) {
            list.add(new SelectItem((Object)role.getName(), role.getDisplayName()));
        }
        return list;
    }

    public List<String> getUserRoles(User user) throws IllegalArgumentException, NoSuchUserException, IdentityException {
        ArrayList<String> list = new ArrayList<String>();
        Set roleSet = this.membershipModule.getRoles(user);
        for (Role role : roleSet) {
            list.add(role.getName());
        }
        return list;
    }
}

