/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.aspects.server;

import java.security.Principal;
import java.util.Date;
import java.util.HashMap;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.http.HttpServletRequest;
import org.jboss.logging.Logger;
import org.jboss.portal.common.invocation.AttributeResolver;
import org.jboss.portal.common.invocation.InvocationException;
import org.jboss.portal.identity.CachedUserImpl;
import org.jboss.portal.identity.NoSuchUserException;
import org.jboss.portal.identity.User;
import org.jboss.portal.identity.UserModule;
import org.jboss.portal.identity.UserProfileModule;
import org.jboss.portal.server.ServerInterceptor;
import org.jboss.portal.server.ServerInvocation;

public class UserInterceptor
extends ServerInterceptor {
    public static final String PROFILE_KEY = "profile";
    public static final String USER_KEY = "user";
    private static final Logger log = Logger.getLogger(UserInterceptor.class);
    protected UserModule userModule = null;
    protected UserProfileModule userProfileModule = null;
    protected boolean cacheUser = true;

    public UserModule getUserModule() {
        if (this.userModule == null) {
            try {
                this.userModule = (UserModule)new InitialContext().lookup("java:portal/UserModule");
            }
            catch (NamingException e) {
                log.error((Object)"could not obtain User Module: ", (Throwable)e);
            }
        }
        return this.userModule;
    }

    public UserProfileModule getUserProfileModule() {
        if (this.userProfileModule == null) {
            try {
                this.userProfileModule = (UserProfileModule)new InitialContext().lookup("java:portal/UserProfileModule");
            }
            catch (NamingException e) {
                log.error((Object)"could not obtain UserProfileModule: ", (Throwable)e);
            }
        }
        return this.userProfileModule;
    }

    public void setUserModule(UserModule userModule) {
        this.userModule = userModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invoke(ServerInvocation invocation) throws Exception, InvocationException {
        boolean trace = log.isTraceEnabled();
        HttpServletRequest req = invocation.getServerContext().getClientRequest();
        AttributeResolver principalScopeResolver = invocation.getContext().getAttributeResolver(ServerInvocation.PRINCIPAL_SCOPE);
        Principal userPrincipal = req.getUserPrincipal();
        User user = null;
        HashMap profile = null;
        if (userPrincipal != null) {
            String userName = userPrincipal.getName();
            try {
                if (trace) {
                    log.trace((Object)("About to fetch user=" + userName));
                }
                if ((user = (User)principalScopeResolver.getAttribute((Object)USER_KEY)) == null) {
                    user = this.getUserModule().findUserByUserName(userName);
                    this.getUserProfileModule().setProperty(user, "portal.user.last-login-date", (Object)("" + new Date().getTime()));
                    this.getUserProfileModule().setProperty(user, "user.login.id", (Object)userName);
                    profile = this.getUserProfileModule().getProperties(user);
                    user = new CachedUserImpl(user.getId(), user.getUserName());
                    invocation.getContext().setAttribute(ServerInvocation.PRINCIPAL_SCOPE, (Object)USER_KEY, (Object)user);
                    profile = new HashMap(profile);
                    invocation.getContext().setAttribute(ServerInvocation.PRINCIPAL_SCOPE, (Object)PROFILE_KEY, profile);
                }
                if (trace) {
                    log.trace((Object)("Found user=" + userName));
                }
            }
            catch (NoSuchUserException e) {
                if (trace) {
                    log.trace((Object)("User not found " + userName + " for principal " + userName + ", will use no user instead"));
                }
            }
            catch (Exception e) {
                log.error((Object)("Cannot retrieve user=" + userName), (Throwable)e);
                throw new InvocationException("Cannot fetch user=" + userName, (Throwable)e);
            }
        }
        try {
            invocation.invokeNext();
        }
        finally {
            if (!this.cacheUser) {
                principalScopeResolver.setAttribute((Object)USER_KEY, null);
                principalScopeResolver.setAttribute((Object)PROFILE_KEY, null);
            }
        }
    }

    public boolean isCacheUser() {
        return this.cacheUser;
    }

    public void setCacheUser(boolean cacheUser) {
        this.cacheUser = cacheUser;
    }
}

