/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.controller;

import java.io.IOException;
import javax.servlet.ServletException;
import org.jboss.portal.common.invocation.InterceptorStackFactory;
import org.jboss.portal.core.controller.CommandRedirectionException;
import org.jboss.portal.core.controller.ControllerCommand;
import org.jboss.portal.core.controller.ControllerContext;
import org.jboss.portal.core.controller.ControllerException;
import org.jboss.portal.core.controller.ControllerResponse;
import org.jboss.portal.core.controller.command.mapper.CommandFactory;
import org.jboss.portal.core.controller.command.mapper.URLFactory;
import org.jboss.portal.core.controller.command.response.ErrorResponse;
import org.jboss.portal.core.controller.coordination.CoordinationConfigurator;
import org.jboss.portal.core.controller.coordination.CoordinationManager;
import org.jboss.portal.core.controller.handler.AjaxResponse;
import org.jboss.portal.core.controller.handler.CommandForward;
import org.jboss.portal.core.controller.handler.HTTPResponse;
import org.jboss.portal.core.controller.handler.HandlerResponse;
import org.jboss.portal.core.controller.handler.ResponseForward;
import org.jboss.portal.core.controller.handler.ResponseHandler;
import org.jboss.portal.core.controller.handler.ResponseHandlerException;
import org.jboss.portal.core.impl.model.content.InternalContentProviderRegistry;
import org.jboss.portal.core.model.CustomizationManager;
import org.jboss.portal.core.model.instance.InstanceContainer;
import org.jboss.portal.core.model.portal.PortalObjectContainer;
import org.jboss.portal.core.model.portal.content.ContentRendererRegistry;
import org.jboss.portal.core.model.portal.control.page.PageControlPolicy;
import org.jboss.portal.jems.as.system.AbstractJBossService;
import org.jboss.portal.security.spi.auth.PortalAuthorizationManagerFactory;
import org.jboss.portal.server.RequestController;
import org.jboss.portal.server.ServerException;
import org.jboss.portal.server.ServerInvocation;
import org.jboss.portal.theme.PageService;

public class Controller
extends AbstractJBossService
implements RequestController {
    protected PageService pageService;
    protected CommandFactory commandFactory;
    protected URLFactory urlFactory;
    protected InterceptorStackFactory stackFactory;
    protected PortalObjectContainer portalObjectContainer;
    protected InstanceContainer instanceContainer;
    protected PortalAuthorizationManagerFactory portalAuthorizationManagerFactory;
    protected CustomizationManager customizationManager;
    protected ContentRendererRegistry contentRendererRegistry;
    protected ResponseHandler responseHandler;
    protected PageControlPolicy pageControlPolicy;
    protected InternalContentProviderRegistry contentProviderRegistry;
    protected CoordinationConfigurator coordinationConfigurator;
    protected CoordinationManager coordinationManager;

    public InternalContentProviderRegistry getContentProviderRegistry() {
        return this.contentProviderRegistry;
    }

    public void setContentProviderRegistry(InternalContentProviderRegistry contentProviderRegistry) {
        this.contentProviderRegistry = contentProviderRegistry;
    }

    public ContentRendererRegistry getContentRendererRegistry() {
        return this.contentRendererRegistry;
    }

    public void setContentRendererRegistry(ContentRendererRegistry contentRendererRegistry) {
        this.contentRendererRegistry = contentRendererRegistry;
    }

    public CustomizationManager getCustomizationManager() {
        return this.customizationManager;
    }

    public void setCustomizationManager(CustomizationManager customizationManager) {
        this.customizationManager = customizationManager;
    }

    public PortalAuthorizationManagerFactory getPortalAuthorizationManagerFactory() {
        return this.portalAuthorizationManagerFactory;
    }

    public void setPortalAuthorizationManagerFactory(PortalAuthorizationManagerFactory portalAuthorizationManagerFactory) {
        this.portalAuthorizationManagerFactory = portalAuthorizationManagerFactory;
    }

    public InstanceContainer getInstanceContainer() {
        return this.instanceContainer;
    }

    public void setInstanceContainer(InstanceContainer instanceContainer) {
        this.instanceContainer = instanceContainer;
    }

    public PortalObjectContainer getPortalObjectContainer() {
        return this.portalObjectContainer;
    }

    public void setPortalObjectContainer(PortalObjectContainer portalObjectContainer) {
        this.portalObjectContainer = portalObjectContainer;
    }

    public URLFactory getURLFactory() {
        return this.urlFactory;
    }

    public void setURLFactory(URLFactory urlFactory) {
        this.urlFactory = urlFactory;
    }

    public CommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    public void setCommandFactory(CommandFactory commandFactory) {
        this.commandFactory = commandFactory;
    }

    public PageService getPageService() {
        return this.pageService;
    }

    public void setPageService(PageService pageService) {
        this.pageService = pageService;
    }

    public InterceptorStackFactory getStackFactory() {
        return this.stackFactory;
    }

    public void setStackFactory(InterceptorStackFactory stackFactory) {
        this.stackFactory = stackFactory;
    }

    public ResponseHandler getResponseHandler() {
        return this.responseHandler;
    }

    public void setResponseHandler(ResponseHandler responseHandler) {
        this.responseHandler = responseHandler;
    }

    public PageControlPolicy getPageControlPolicy() {
        return this.pageControlPolicy;
    }

    public void setPageControlPolicy(PageControlPolicy pageControlPolicy) {
        this.pageControlPolicy = pageControlPolicy;
    }

    public CoordinationConfigurator getCoordinationConfigurator() {
        return this.coordinationConfigurator;
    }

    public void setCoordinationConfigurator(CoordinationConfigurator coordinationConfigurator) {
        this.coordinationConfigurator = coordinationConfigurator;
    }

    public CoordinationManager getCoordinationManager() {
        return this.coordinationManager;
    }

    public void setCoordinationManager(CoordinationManager coordinationManager) {
        this.coordinationManager = coordinationManager;
    }

    public final void handle(ServerInvocation invocation) throws ServerException {
        ControllerContext controllerContext = new ControllerContext(invocation, this);
        ControllerCommand cmd = this.commandFactory.doMapping(controllerContext, invocation, invocation.getServerContext().getPortalHost(), invocation.getServerContext().getPortalContextPath(), invocation.getServerContext().getPortalRequestPath());
        if (cmd == null) {
            throw new ServerException("No command was produced by the command factory");
        }
        this.processCommand(controllerContext, cmd);
    }

    protected void processCommand(ControllerContext controllerContext, ControllerCommand command) throws ServerException {
        ControllerResponse response;
        try {
            response = controllerContext.execute(command);
        }
        catch (CommandRedirectionException e) {
            this.processHandlerResponse(controllerContext, command, new CommandForward(e.getRedirection(), null));
            return;
        }
        catch (ControllerException e) {
            response = new ErrorResponse(e, true);
        }
        if (response == null) {
            response = new ErrorResponse("No response was provided by the invocation of " + (Object)((Object)command), true);
        }
        this.processCommandResponse(controllerContext, command, response);
    }

    protected void processCommandResponse(ControllerContext controllerContext, ControllerCommand command, ControllerResponse response) throws ServerException {
        HandlerResponse handlerResponse;
        try {
            handlerResponse = this.responseHandler.processCommandResponse(controllerContext, command, response);
        }
        catch (ResponseHandlerException e) {
            throw new ServerException((Throwable)e);
        }
        if (handlerResponse == null) {
            return;
        }
        this.processHandlerResponse(controllerContext, command, handlerResponse);
    }

    protected void processHandlerResponse(ControllerContext controllerContext, ControllerCommand command, HandlerResponse handlerResponse) throws ServerException {
        if (handlerResponse instanceof CommandForward) {
            CommandForward forward = (CommandForward)handlerResponse;
            this.processCommand(controllerContext, forward.getCommand());
        } else if (handlerResponse instanceof ResponseForward) {
            ResponseForward forward = (ResponseForward)handlerResponse;
            ControllerResponse response = forward.getResponse();
            this.processCommandResponse(controllerContext, command, response);
        } else if (handlerResponse instanceof HTTPResponse) {
            HTTPResponse hr = (HTTPResponse)handlerResponse;
            this.sendResponse(controllerContext, hr);
        } else if (handlerResponse instanceof AjaxResponse) {
            AjaxResponse ar = (AjaxResponse)handlerResponse;
            this.sendResponse(controllerContext, ar);
        }
    }

    protected void sendResponse(ControllerContext ctx, HTTPResponse resp) {
        try {
            resp.sendResponse(ctx.getServerInvocation().getServerContext());
        }
        catch (IOException e) {
            this.log.error((Object)"Cound not send http response", (Throwable)e);
        }
        catch (ServletException e) {
            this.log.error((Object)"Cound not send http response", (Throwable)e);
        }
    }

    protected void sendResponse(ControllerContext ctx, AjaxResponse resp) {
        try {
            resp.sendResponse(ctx.getServerInvocation().getServerContext());
        }
        catch (IOException e) {
            this.log.error((Object)"Cound not send http response", (Throwable)e);
        }
        catch (ServletException e) {
            this.log.error((Object)"Cound not send http response", (Throwable)e);
        }
    }
}

