/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.identity.cache;

import java.util.Map;
import org.jboss.logging.Logger;
import org.jboss.portal.core.identity.cache.IdentityCacheService;
import org.jboss.portal.identity.IdentityException;
import org.jboss.portal.identity.User;
import org.jboss.portal.identity.UserProfileModule;
import org.jboss.portal.identity.info.ProfileInfo;

public class CachedUserProfileModuleWrapper
implements UserProfileModule {
    private static final Logger log = Logger.getLogger(CachedUserProfileModuleWrapper.class);
    private UserProfileModule userProfileModule;
    private IdentityCacheService cacheService;

    public CachedUserProfileModuleWrapper(UserProfileModule userProfileModule, IdentityCacheService identityCacheService) {
        this.userProfileModule = userProfileModule;
        this.cacheService = identityCacheService;
    }

    public Object getProperty(User user, String propertyName) throws IdentityException, IllegalArgumentException {
        Map profile = this.getProperties(user);
        if (profile != null && profile.containsKey(propertyName)) {
            return profile.get(propertyName);
        }
        return this.userProfileModule.getProperty(user, propertyName);
    }

    public void setProperty(User user, String name, Object property) throws IdentityException, IllegalArgumentException {
        this.userProfileModule.setProperty(user, name, property);
        this.cacheService.invalidateProfile(user);
    }

    public Map getProperties(User user) throws IdentityException, IllegalArgumentException {
        Map profile = this.cacheService.findUserProfileById(user.getId());
        if (profile != null) {
            return profile;
        }
        profile = this.userProfileModule.getProperties(user);
        this.cacheService.storeProfile(user, profile);
        return profile;
    }

    public ProfileInfo getProfileInfo() throws IdentityException {
        return this.userProfileModule.getProfileInfo();
    }
}

