/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.model.portal.command.action;

import java.util.Map;
import org.jboss.portal.common.util.ParameterMap;
import org.jboss.portal.core.controller.ControllerCommand;
import org.jboss.portal.core.controller.ControllerException;
import org.jboss.portal.core.controller.command.info.ActionCommandInfo;
import org.jboss.portal.core.controller.command.info.CommandInfo;
import org.jboss.portal.core.controller.portlet.ControllerPageNavigationalState;
import org.jboss.portal.core.controller.portlet.ControllerPortletControllerContext;
import org.jboss.portal.core.controller.portlet.ControllerResponseFactory;
import org.jboss.portal.core.model.portal.PortalObjectId;
import org.jboss.portal.core.model.portal.command.action.InvokeWindowCommand;
import org.jboss.portal.core.model.portal.navstate.PageNavigationalState;
import org.jboss.portal.core.navstate.NavigationalStateContext;
import org.jboss.portal.portlet.PortletInvokerException;
import org.jboss.portal.portlet.StateString;
import org.jboss.portal.portlet.cache.CacheLevel;
import org.jboss.portal.portlet.controller.PortletController;
import org.jboss.portal.portlet.controller.PortletControllerContext;
import org.jboss.portal.portlet.controller.request.ContainerRequest;
import org.jboss.portal.portlet.controller.request.ControllerRequest;
import org.jboss.portal.portlet.controller.request.PortletResourceRequest;
import org.jboss.portal.portlet.controller.response.ControllerResponse;
import org.jboss.portal.portlet.controller.response.ResourceResponse;
import org.jboss.portal.portlet.controller.state.PortletPageNavigationalState;
import org.jboss.portal.portlet.controller.state.PortletWindowNavigationalState;
import org.jboss.portal.portlet.info.PortletInfo;

public class InvokePortletWindowResourceCommand
extends InvokeWindowCommand {
    private static final CommandInfo info = new ActionCommandInfo(true);
    private final CacheLevel cacheability;
    private final String resourceId;
    private final StateString resourceState;
    private final ParameterMap resourceForm;

    public InvokePortletWindowResourceCommand(PortalObjectId windowId, CacheLevel cacheability, String resourceId, StateString resourceState, ParameterMap resourceForm) throws IllegalArgumentException {
        super(windowId);
        if (cacheability == null) {
            throw new IllegalArgumentException("No null cache level accepted");
        }
        this.cacheability = cacheability;
        this.resourceId = resourceId;
        this.resourceState = resourceState;
        this.resourceForm = resourceForm;
    }

    public CacheLevel getCacheability() {
        return this.cacheability;
    }

    public String getResourceId() {
        return this.resourceId;
    }

    public StateString getResourceState() {
        return this.resourceState;
    }

    public CommandInfo getInfo() {
        return info;
    }

    protected ContainerRequest createPortletRequest(PortletInfo portletInfo, PortletPageNavigationalState pageNS, PortletWindowNavigationalState windowNS) {
        PortletResourceRequest.FullScope scope;
        if (windowNS == null) {
            windowNS = new PortletWindowNavigationalState();
        }
        switch (this.cacheability) {
            case FULL: {
                scope = new PortletResourceRequest.FullScope();
                break;
            }
            case PORTLET: {
                scope = new PortletResourceRequest.PortletScope(windowNS);
                break;
            }
            case PAGE: {
                scope = new PortletResourceRequest.PageScope(windowNS, pageNS);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return new PortletResourceRequest(this.window.getName(), this.resourceId, this.resourceState, (Map)this.resourceForm, (PortletResourceRequest.Scope)scope);
    }

    public org.jboss.portal.core.controller.ControllerResponse execute() throws ControllerException {
        try {
            ControllerPortletControllerContext cpcc = new ControllerPortletControllerContext(this.context, this.page);
            ControllerPageNavigationalState pageNS = cpcc.getStateControllerContext().createPortletPageNavigationalState(false);
            PortletWindowNavigationalState windowNS = pageNS.getPortletWindowNavigationalState(this.window.getName());
            PortletInfo portletInfo = cpcc.getPortletInfo(this.window.getName());
            ContainerRequest containerRequest = this.createPortletRequest(portletInfo, pageNS, windowNS);
            PortletController controller = new PortletController();
            ControllerResponse cr = controller.process((PortletControllerContext)cpcc, (ControllerRequest)containerRequest);
            ResourceResponse resourceResponse = (ResourceResponse)cr;
            NavigationalStateContext ctx = (NavigationalStateContext)cpcc.getControllerContext().getAttributeResolver(ControllerCommand.NAVIGATIONAL_STATE_SCOPE);
            PageNavigationalState pns = ctx.getPageNavigationalState(this.page.getId().toString());
            return ControllerResponseFactory.createActionResponse(this.targetId, resourceResponse.getResponse(), portletInfo, pns);
        }
        catch (PortletInvokerException e) {
            return ControllerResponseFactory.createResponse(e);
        }
    }
}

