/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.core.theme;

import java.io.IOException;
import javax.servlet.ServletException;
import org.jboss.portal.common.util.MarkupInfo;
import org.jboss.portal.core.controller.ControllerResponse;
import org.jboss.portal.theme.PageService;
import org.jboss.portal.theme.PortalLayout;
import org.jboss.portal.theme.PortalTheme;
import org.jboss.portal.theme.ThemeServiceInfo;
import org.jboss.portal.theme.page.PageResult;
import org.jboss.portal.theme.render.ObjectRendererContext;
import org.jboss.portal.theme.render.RenderException;
import org.jboss.portal.theme.render.RendererContext;
import org.jboss.portal.theme.render.ThemeContext;
import org.jboss.portal.web.ServletContextDispatcher;

public class PageRendition
extends ControllerResponse {
    private PortalLayout layout;
    private PageResult pageResult;
    private PortalTheme theme;
    private PageService pageService;

    public PageRendition(PortalLayout layout, PortalTheme theme, PageResult markupResult, PageService pageService) {
        this.layout = layout;
        this.theme = theme;
        this.pageResult = markupResult;
        this.pageService = pageService;
    }

    public void render(MarkupInfo markupInfo, ServletContextDispatcher dispatcher) throws IOException, ServletException {
        String contentType = markupInfo.getMediaType().getValue() + "; charset=" + markupInfo.getCharset();
        dispatcher.getResponse().setContentType(contentType);
        dispatcher.getResponse().setCharacterEncoding(markupInfo.getCharset());
        ThemeContext themeContext = new ThemeContext(this.theme, (ThemeServiceInfo)this.pageService.getThemeService());
        RendererContext rendererContext = this.layout.getRenderContext(themeContext, markupInfo, dispatcher);
        try {
            rendererContext.render((ObjectRendererContext)this.pageResult);
        }
        catch (RenderException e) {
            e.printStackTrace();
        }
    }

    public PageResult getPageResult() {
        return this.pageResult;
    }
}

