/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.auth;

import java.security.Principal;
import java.security.acl.Group;
import java.util.Map;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.portal.identity.auth.UserPrincipal;
import org.jboss.security.auth.spi.DatabaseServerLoginModule;

public class DBIdentityLoginModule
extends DatabaseServerLoginModule {
    private String additionalRole;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
        this.additionalRole = (String)options.get("additionalRole");
        this.log.trace((Object)("additionalRole = " + this.additionalRole));
    }

    protected Group[] getRoleSets() throws LoginException {
        Group[] rolesGroup = super.getRoleSets();
        if (this.additionalRole != null) {
            try {
                for (int i = 0; i < rolesGroup.length; ++i) {
                    Group group = rolesGroup[i];
                    if (!group.getName().equals("Roles")) continue;
                    group.addMember(this.createIdentity(this.additionalRole));
                }
            }
            catch (Exception e) {
                this.log.error((Object)"Error when adding additional role: ", (Throwable)e);
            }
        }
        return rolesGroup;
    }

    protected Principal createIdentity(String username) throws Exception {
        return new UserPrincipal(username);
    }
}

