/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.identity.metadata.config;

import java.util.HashMap;
import java.util.Map;
import org.jboss.portal.identity.metadata.config.ConfigOptionMetaData;
import org.jboss.portal.identity.metadata.config.DatasourceMetaData;
import org.jboss.portal.identity.metadata.config.ModuleMetaData;
import org.jboss.portal.identity.metadata.config.OptionsGroupMetaData;
import org.jboss.portal.identity.metadata.config.OptionsGroupOptionMetaData;
import org.jboss.portal.identity.metadata.config.OptionsMetaData;
import org.jboss.portal.identity.service.IdentityConfigurationService;

public class IdentityMetadataProcessor {
    public static void updateModuleWithDefaults(ModuleMetaData module, Map defaultModules) {
        if (module.getImplementation() == null) {
            return;
        }
        if (!defaultModules.containsKey(module.getImplementation())) {
            return;
        }
        Map modules = (Map)defaultModules.get(module.getImplementation());
        if (!modules.containsKey(module.getType())) {
            return;
        }
        ModuleMetaData def = (ModuleMetaData)modules.get(module.getType());
        if (module.getClassName() == null) {
            module.setClassName(def.getClassName());
        }
        if (module.getServiceName() == null) {
            module.setServiceName(def.getServiceName());
        }
        if (module.getConfig() == null) {
            module.setConfig(def.getConfig());
        } else {
            Map moduleOptions = module.getConfig().getOptions();
            if (moduleOptions == null) {
                return;
            }
            Map defOptions = def.getConfig().getOptions();
            for (String key : defOptions.keySet()) {
                if (moduleOptions.containsKey(key)) continue;
                ConfigOptionMetaData o = (ConfigOptionMetaData)defOptions.get(key);
                module.getConfig().addOption(o);
            }
        }
    }

    public static void updateDatasourceWithDefaults(DatasourceMetaData ds, Map defaultDS) {
        if (ds.getName() == null) {
            return;
        }
        if (!defaultDS.containsKey(ds.getName())) {
            return;
        }
        DatasourceMetaData def = (DatasourceMetaData)defaultDS.get(ds.getName());
        if (ds.getClassName() == null) {
            ds.setClassName(def.getClassName());
        }
        if (ds.getServiceName() == null) {
            ds.setServiceName(def.getServiceName());
        }
        if (ds.getConfig() == null) {
            ds.setConfig(def.getConfig());
        } else {
            Map dsOptions = ds.getConfig().getOptions();
            if (dsOptions == null) {
                return;
            }
            Map defOptions = def.getConfig().getOptions();
            for (String key : defOptions.keySet()) {
                if (dsOptions.containsKey(key)) continue;
                ConfigOptionMetaData o = (ConfigOptionMetaData)defOptions.get(key);
                ds.getConfig().addOption(o);
            }
        }
    }

    public static void updateOptionsWithDefaults(IdentityConfigurationService config, OptionsMetaData defaults) {
        Map groups = defaults.getGroups();
        for (String groupKey : groups.keySet()) {
            OptionsGroupMetaData group = (OptionsGroupMetaData)groups.get(groupKey);
            if (config.getOptions(groupKey) == null) {
                config.setOptions(groupKey, new HashMap());
            }
            Map options = group.getOptions();
            for (String optionKey : options.keySet()) {
                OptionsGroupOptionMetaData option = (OptionsGroupOptionMetaData)options.get(optionKey);
                if (config.getValues(groupKey, optionKey) != null) continue;
                config.setValues(groupKey, optionKey, option.getValues());
            }
        }
    }
}

