/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.portail.cms.nuxeo.api;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.VocabularyEntry;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Blob;
import org.osivia.portal.api.cache.services.CacheInfo;

public class VocabularyHelper {
    private static VocabularyEntry callCommand(NuxeoController nuxeoController, List<String> vocabularyNames, boolean multiLevel) {
        NuxeoController vocabularyController = new NuxeoController(nuxeoController.getRequest(), nuxeoController.getResponse(), nuxeoController.getPortletCtx());
        vocabularyController.setCacheTimeOut(TimeUnit.HOURS.toMillis(1L));
        vocabularyController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        vocabularyController.setCacheType(CacheInfo.CACHE_SCOPE_PORTLET_CONTEXT);
        VocabularyLoaderCommand command = new VocabularyLoaderCommand(vocabularyNames, multiLevel);
        return (VocabularyEntry)vocabularyController.executeNuxeoCommand(command);
    }

    public static String getVocabularyLabel(NuxeoController nuxeoController, List<String> vocabularyNames, String key) {
        VocabularyEntry child;
        String label = null;
        VocabularyEntry vocabularyEntry = VocabularyHelper.callCommand(nuxeoController, vocabularyNames, false);
        if (vocabularyEntry != null && (child = vocabularyEntry.getChild(key)) != null) {
            label = child.getLabel();
        }
        return label;
    }

    public static String getVocabularyLabel(NuxeoController nuxeoController, String vocabularyName, String key) {
        ArrayList<String> vocabularyNames = new ArrayList<String>(1);
        vocabularyNames.add(vocabularyName);
        return VocabularyHelper.getVocabularyLabel(nuxeoController, vocabularyNames, key);
    }

    public static VocabularyEntry getVocabularyEntry(NuxeoController nuxeoController, List<String> vocabularyNames, Boolean multiLevel) {
        return VocabularyHelper.callCommand(nuxeoController, vocabularyNames, multiLevel);
    }

    public static VocabularyEntry getVocabularyEntry(NuxeoController nuxeoController, String vocabularyName, boolean multiLevel) {
        ArrayList<String> vocabularyNames = new ArrayList<String>(1);
        vocabularyNames.add(vocabularyName);
        return VocabularyHelper.getVocabularyEntry(nuxeoController, vocabularyNames, (Boolean)multiLevel);
    }

    public static VocabularyEntry getVocabularyEntry(NuxeoController nuxeoController, String vocabularyName) {
        return VocabularyHelper.getVocabularyEntry(nuxeoController, vocabularyName, false);
    }

    public static VocabularyEntry getVocabularyEntry(NuxeoController nuxeoController, List<String> vocabularyNames) {
        return VocabularyHelper.getVocabularyEntry(nuxeoController, vocabularyNames, (Boolean)false);
    }

    private static class VocabularyLoaderCommand
    implements INuxeoCommand {
        private String vocabularyNames;
        private final boolean multiLevel;

        public VocabularyLoaderCommand(List<String> vocabNames, boolean multiLevel) {
            this.vocabularyNames = StringUtils.join(vocabNames, (String)";");
            this.multiLevel = multiLevel;
        }

        private VocabularyEntry parseVocabularies(VocabularyEntry parent, JSONArray vocabulariesObj) throws UnsupportedEncodingException {
            VocabularyEntry entry = null;
            if (null == parent) {
                parent = new VocabularyEntry("root", "root");
            }
            if (!vocabulariesObj.isEmpty()) {
                for (JSONObject vocabulary : vocabulariesObj) {
                    String key = vocabulary.getString("key");
                    String label = vocabulary.getString("value");
                    String parentId = null;
                    if (vocabulary.containsKey((Object)"parent")) {
                        parentId = vocabulary.getString("parent");
                    }
                    if (label.startsWith("label.directories")) {
                        label = key;
                    }
                    String DecodedLabel = URLDecoder.decode(label, "UTF-8");
                    entry = new VocabularyEntry(key, DecodedLabel);
                    JSONArray children = null;
                    if (vocabulary.has("children") && null != (children = vocabulary.getJSONArray("children"))) {
                        this.parseVocabularies(entry, children);
                    }
                    if (this.multiLevel && StringUtils.isNotBlank((String)parentId)) {
                        VocabularyEntry parentVoc = parent.getChildren().get(parentId);
                        if (parentVoc == null) continue;
                        parentVoc.getChildren().put(entry.getId(), entry);
                        continue;
                    }
                    parent.getChildren().put(entry.getId(), entry);
                }
            }
            return entry;
        }

        public boolean isAChild(String id, VocabularyEntry vocab) {
            for (Map.Entry<String, VocabularyEntry> entry : vocab.getChildren().entrySet()) {
                VocabularyEntry child = entry.getValue();
                if (!"key_root".equals(vocab.getId()) && id.equals(child.getId())) {
                    return true;
                }
                if (!this.isAChild(id, child)) continue;
                return true;
            }
            return false;
        }

        public void removeDuplicatedChilds(VocabularyEntry vocab) {
            ArrayList<String> removedEntries = new ArrayList<String>();
            for (Map.Entry<String, VocabularyEntry> entry : vocab.getChildren().entrySet()) {
                VocabularyEntry child = entry.getValue();
                if (!this.isAChild(child.getId(), vocab)) continue;
                removedEntries.add(child.getId());
            }
            for (String key : removedEntries) {
                vocab.getChildren().remove(key);
            }
        }

        @Override
        public Object execute(Session nuxeoSession) throws Exception {
            OperationRequest operationRequest = nuxeoSession.newRequest("Document.GetVocabularies");
            operationRequest.setHeader("X-NXDocumentProperties", "*");
            operationRequest.set("vocabularies", (Object)this.vocabularyNames);
            Blob blob = (Blob)operationRequest.execute();
            String content = IOUtils.toString((InputStream)blob.getStream(), (String)"UTF-8");
            JSONObject rootObject = new JSONObject();
            rootObject.element("key", (Object)"key_root");
            rootObject.element("value", (Object)"value_root");
            rootObject.element("children", (Collection)JSONArray.fromObject((Object)content));
            JSONArray root = new JSONArray();
            root.element(rootObject);
            VocabularyEntry entries = this.parseVocabularies(null, root);
            this.removeDuplicatedChilds(entries);
            return entries;
        }

        @Override
        public String getId() {
            StringBuilder builder = new StringBuilder();
            builder.append(this.getClass().getCanonicalName());
            builder.append("/");
            builder.append(this.vocabularyNames);
            builder.append("/");
            builder.append(this.multiLevel);
            return builder.toString();
        }
    }
}

