/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.theme;

import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.jboss.portal.theme.LayoutInfo;
import org.jboss.portal.theme.render.RendererContext;
import org.jboss.portal.theme.render.renderer.PageRendererContext;
import org.jboss.portal.web.RequestDispatchCallback;
import org.jboss.portal.web.ServletContextDispatcher;

public final class LayoutDispatcher
implements RequestDispatchCallback {
    private final PageRendererContext markupResult;
    private final RendererContext rendererContext;
    private final String layoutURI;
    private final LayoutInfo layoutInfo;

    public LayoutDispatcher(RendererContext rendererContext, PageRendererContext result, String layoutURI, LayoutInfo layoutInfo) throws IllegalArgumentException {
        if (result == null) {
            throw new IllegalArgumentException("No null response allowed here");
        }
        if (rendererContext == null) {
            throw new IllegalArgumentException("No render context provided");
        }
        if (layoutURI == null) {
            throw new IllegalArgumentException("No null layout allowed here");
        }
        this.markupResult = result;
        this.rendererContext = rendererContext;
        this.layoutURI = layoutURI;
        this.layoutInfo = layoutInfo;
    }

    public void include() throws IOException, ServletException {
        try {
            ServletContextDispatcher dispatcher = this.rendererContext.getDispatcher();
            dispatcher.include(this.layoutInfo.getServletContext(), (RequestDispatchCallback)this, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object doCallback(ServletContext dispatchedServletContext, HttpServletRequest dispatchedRequest, HttpServletResponse dispatchedResponse, Object handback) throws ServletException, IOException {
        try {
            RequestDispatcher dispatcher = dispatchedServletContext.getRequestDispatcher(this.layoutURI);
            dispatchedRequest.setAttribute("RENDERCONTEXT", (Object)this.rendererContext);
            dispatchedRequest.setAttribute("org.jboss.portal.portlet.servlet.FilterCommand", (Object)this);
            dispatchedRequest.setAttribute("PAGE", (Object)this.markupResult);
            HttpServletRequestWrapper requestWrapper = new HttpServletRequestWrapper(dispatchedRequest){

                public String getContextPath() {
                    return LayoutDispatcher.this.layoutInfo.getContextPath();
                }
            };
            dispatcher.include((ServletRequest)requestWrapper, (ServletResponse)dispatchedResponse);
        }
        finally {
            dispatchedRequest.removeAttribute("PAGE");
            dispatchedRequest.removeAttribute("RENDERCONTEXT");
        }
        return null;
    }
}

