/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.portal.theme;

import java.util.Collections;
import java.util.List;
import javax.servlet.ServletContext;
import org.jboss.portal.theme.RuntimeContext;
import org.jboss.portal.theme.ServerRegistrationID;
import org.jboss.portal.theme.metadata.PortalLayoutMetaData;
import org.jboss.portal.theme.metadata.StateURIMetaData;

public final class LayoutInfo {
    private final RuntimeContext ctx;
    private final PortalLayoutMetaData layoutMD;
    private final ServerRegistrationID registrationId;

    public LayoutInfo(RuntimeContext ctx, PortalLayoutMetaData layoutMD) {
        this.ctx = ctx;
        this.layoutMD = layoutMD;
        this.registrationId = ServerRegistrationID.createID(ServerRegistrationID.TYPE_LAYOUT, new String[]{ctx.getAppId(), layoutMD.getName()});
    }

    public ServerRegistrationID getRegistrationId() {
        return this.registrationId;
    }

    public String getAppId() {
        return this.ctx.getAppId();
    }

    public String getName() {
        return this.layoutMD.getName();
    }

    public ServletContext getServletContext() {
        return this.ctx.getServletContext();
    }

    public String getURI() {
        return this.layoutMD.getURI();
    }

    public String getURI(String state) {
        if (state == null) {
            return this.getURI();
        }
        if (!this.layoutMD.getLayoutURIStateMap().isEmpty()) {
            StateURIMetaData stateURI = (StateURIMetaData)this.layoutMD.getLayoutURIStateMap().get(state);
            if (stateURI != null) {
                return stateURI.getURI();
            }
            return null;
        }
        return null;
    }

    public String getContextPath() {
        return this.ctx.getContextPath();
    }

    public List getRegionNames() {
        return Collections.unmodifiableList(this.layoutMD.getRegionNames());
    }

    public String toString() {
        return "PortalLayout: " + this.registrationId;
    }
}

