/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.integrity.controller;

import fr.gouv.education.foad.integrity.controller.ChgValidDateForm;
import fr.gouv.education.foad.integrity.service.IntegrityService;
import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.NotificationsType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;

@Controller
@RequestMapping(value={"VIEW"})
public class ViewController
extends CMSPortlet
implements PortletConfigAware,
PortletContextAware {
    private PortletConfig portletConfig;
    private PortletContext portletContext;
    @Autowired
    private IntegrityService service;
    @Autowired
    protected IBundleFactory bundleFactory;
    @Autowired
    protected INotificationsService notificationsService;

    @PostConstruct
    public void postConstruct() throws PortletException {
        super.init(this.portletConfig);
    }

    @PreDestroy
    public void preDestroy() {
        super.destroy();
    }

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response) {
        return "view";
    }

    @ExceptionHandler
    public String exceptionHandler(PortletRequest request, PortletResponse response) throws PortletException {
        return "error";
    }

    @ActionMapping(value="checkIntegrity")
    public void checkIntegrity(ActionRequest request, ActionResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        String repare = request.getParameter("repare");
        this.service.checkIntegrity(portalControllerContext, BooleanUtils.toBoolean((String)repare));
    }

    @ActionMapping(value="purgeUsers")
    public void purgeUsers(ActionRequest request, ActionResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        String purge = request.getParameter("purge");
        this.service.purgeUsers(portalControllerContext, BooleanUtils.toBoolean((String)purge));
    }

    @ModelAttribute
    public ChgValidDateForm getChgValidDateForm() {
        return new ChgValidDateForm();
    }

    @ActionMapping(value="chgValidDate")
    public void chgValidDate(@ModelAttribute ChgValidDateForm form, ActionRequest request, ActionResponse response) {
        PortalControllerContext pcc = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        IBundleFactory bundleFactory2 = this.getBundleFactory();
        Bundle bundle = bundleFactory2.getBundle(null);
        String button = request.getParameter("btnName");
        boolean test = true;
        if (StringUtils.isNotBlank((String)button) && "run".equals(button)) {
            test = false;
        }
        Date validity = null;
        Date current = null;
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        try {
            validity = sdf.parse(form.getValidityDate());
        }
        catch (ParseException e) {
            this.getNotificationsService().addSimpleNotification(pcc, bundle.getString("VALIDITY_DATE_ERROR"), NotificationsType.ERROR);
        }
        if (validity != null) {
            if (StringUtils.isNotBlank((String)form.getCurrentDate())) {
                try {
                    current = sdf.parse(form.getCurrentDate());
                }
                catch (ParseException e) {
                    this.getNotificationsService().addSimpleNotification(pcc, bundle.getString("CURRENT_DATE_ERROR"), NotificationsType.ERROR);
                }
            }
            Integer accountModified = 0;
            if (current != null && StringUtils.isNotBlank((String)form.getLogins()) || current == null && StringUtils.isBlank((String)form.getLogins())) {
                this.getNotificationsService().addSimpleNotification(pcc, bundle.getString("METHOD_NOT_CHOOSE"), NotificationsType.ERROR);
            }
            if (current != null) {
                accountModified = this.service.chgValidDate(validity, current, Boolean.valueOf(test));
            } else if (StringUtils.isNotBlank((String)form.getLogins())) {
                String[] split = form.getLogins().split(";");
                ArrayList<String> logins = new ArrayList<String>();
                for (int i = 0; i < split.length; ++i) {
                    String trim = StringUtils.trim((String)split[i]);
                    if (!StringUtils.isNotBlank((String)trim)) continue;
                    logins.add(trim);
                }
                accountModified = this.service.chgValidDate(validity, logins, Boolean.valueOf(test));
            }
            this.getNotificationsService().addSimpleNotification(pcc, bundle.getString("VALIDITY_MODIF_OK", new Object[]{accountModified}), NotificationsType.SUCCESS);
        }
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }

    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }
}

