/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.integrity.service;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class GetProceduresInstancesCommand
implements INuxeoCommand {
    private final String modelId;
    private final String step;
    private final String uid;

    public GetProceduresInstancesCommand(String step, String modelId, String uid) {
        this.step = step;
        this.modelId = modelId;
        this.uid = uid;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        StringBuilder clause = new StringBuilder();
        clause.append("ecm:primaryType = 'ProcedureInstance' ");
        if (this.modelId != null) {
            clause.append("AND pi:procedureModelWebId = 'procedure_" + this.modelId + "' ");
        }
        if (this.step != null) {
            clause.append("AND pi:currentStep = '").append(this.step).append("' ");
        }
        if (this.uid != null) {
            clause.append("AND pi:globalVariablesValues.").append("uid").append(" IN (");
            clause.append("'").append(this.uid).append("'");
            clause.append(") ORDER BY dc:created DESC");
        }
        String filteredClause = NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)NuxeoQueryFilterContext.CONTEXT_LIVE, (String)clause.toString());
        OperationRequest request = nuxeoSession.newRequest("Document.QueryES");
        request.set("X-NXDocumentProperties", (Object)"dublincore, procedureInstance");
        request.set("query", (Object)("SELECT * FROM Document WHERE " + filteredClause));
        return request.execute();
    }

    public String getId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getName());
        builder.append("/");
        if (this.step != null) {
            builder.append(this.step);
        }
        builder.append("/");
        return builder.toString();
    }
}

