/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.integrity.service;

import fr.gouv.education.foad.integrity.service.GetProceduresInstancesCommand;
import fr.gouv.education.foad.integrity.service.GetWorkspaceCommand;
import fr.gouv.education.foad.integrity.service.IntegrityService;
import fr.gouv.education.foad.integrity.service.UpdateWorkspaceCommand;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.naming.Name;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.directory.v2.model.CollabProfile;
import org.osivia.directory.v2.model.ext.WorkspaceGroupType;
import org.osivia.directory.v2.service.PersonUpdateService;
import org.osivia.directory.v2.service.WorkspaceService;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.services.workspace.portlet.model.Invitation;
import org.osivia.services.workspace.portlet.repository.MemberManagementRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IntegrityServiceImpl
implements IntegrityService {
    private Log log = LogFactory.getLog((String)"org.osivia.directory.v2");
    @Autowired
    private WorkspaceService wsService;
    @Autowired
    private PersonUpdateService personService;
    @Autowired
    private MemberManagementRepository memberRepo;

    public void checkIntegrity(PortalControllerContext portalControllerContext, boolean repare) throws PortletException {
        NuxeoController nuxeoController = this.getNuxeoController(portalControllerContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_NONE);
        nuxeoController.setAsynchronousCommand(false);
        CollabProfile profile = this.wsService.getEmptyProfile();
        profile.setType(WorkspaceGroupType.space_group);
        List workspaces = this.wsService.findByCriteria(profile);
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        for (CollabProfile workspace : workspaces) {
            String workspaceId = workspace.getWorkspaceId();
            Document workspaceDoc = (Document)nuxeoController.executeNuxeoCommand((INuxeoCommand)new GetWorkspaceCommand(workspaceId));
            try {
                if (workspaceDoc != null) {
                    PropertyList map = workspaceDoc.getProperties().getList("ttcs:spaceMembers");
                    int membersNx = 0;
                    int membersLdap = workspace.getUniqueMember().size();
                    if (map != null) {
                        membersNx = map.size();
                    }
                    String title = workspaceDoc.getString("dc:title");
                    if (membersLdap <= membersNx) continue;
                    Date created = workspaceDoc.getDate("dc:created");
                    this.log.error((Object)(title + " (" + workspaceId + ") cr\u00e9\u00e9 le " + sdf.format(created) + " compte " + membersNx + " membres au lieu de " + membersLdap));
                    ArrayList<String> memberLogins = new ArrayList<String>();
                    for (Object element : map.list()) {
                        PropertyMap pmap = (PropertyMap)element;
                        memberLogins.add(pmap.getString("login"));
                    }
                    for (Name uniqueMember : workspace.getUniqueMember()) {
                        String uid = uniqueMember.get(uniqueMember.size() - 1);
                        uid = uid.replace("uid=", "");
                        this.log.error((Object)(uid + " est manquant et sera ajout\u00e9 \u00e0 l'espace " + title));
                        if (memberLogins.contains(uid) || !repare) continue;
                        nuxeoController.executeNuxeoCommand((INuxeoCommand)new UpdateWorkspaceCommand(workspaceId, uid, true));
                    }
                    continue;
                }
                this.log.error((Object)("Workspace " + workspaceId + " introuvable dans Nuxeo !"));
            }
            catch (Exception e) {
                this.log.error((Object)("Exception sur le workspace " + workspaceId), (Throwable)e);
            }
        }
    }

    private NuxeoController getNuxeoController(PortalControllerContext portalControllerContext) {
        PortletRequest request = portalControllerContext.getRequest();
        PortletResponse response = portalControllerContext.getResponse();
        PortletContext portletContext = portalControllerContext.getPortletCtx();
        return new NuxeoController(request, response, portletContext);
    }

    public void purgeUsers(PortalControllerContext portalControllerContext, boolean purge) {
        Person search = this.personService.getEmptyPerson();
        search.setExternal(Boolean.valueOf(true));
        List persons = this.personService.findByNoConnectionDate(search);
        NuxeoController controller = new NuxeoController(portalControllerContext);
        Date referenceDate = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(referenceDate);
        c.add(2, -2);
        referenceDate = c.getTime();
        int count = 0;
        for (Person p : persons) {
            this.log.info((Object)("No connection date avaliable for " + p.getUid()));
            boolean recentlyInvited = false;
            Documents invitations = (Documents)controller.executeNuxeoCommand((INuxeoCommand)new GetProceduresInstancesCommand("invitation", "invitation", p.getUid()));
            if (invitations.size() > 0) {
                ArrayList<Invitation> form = new ArrayList<Invitation>();
                for (Document invitation : invitations) {
                    Date modified = invitation.getDate("dc:modified");
                    PropertyMap variables = invitation.getProperties().getMap("pi:globalVariablesValues");
                    String workspaceId = variables.get("workspaceId").toString();
                    if (modified.before(referenceDate)) {
                        Invitation invit = new Invitation(p);
                        invit.setDocument(invitation);
                        invit.setDeleted(true);
                        form.add(invit);
                        this.log.info((Object)("Remove invitation for " + p.getUid() + " on " + workspaceId));
                        continue;
                    }
                    this.log.info((Object)("Cannot remove invitation for " + p.getUid() + " on " + workspaceId + " (recently modified)"));
                    recentlyInvited = true;
                }
                try {
                    if (purge) {
                        this.memberRepo.updateInvitations(portalControllerContext, form);
                    }
                    ++count;
                }
                catch (PortletException e) {
                    this.log.error((Object)e);
                }
            } else {
                this.log.info((Object)("No current invitation for " + p.getUid()));
            }
            if (recentlyInvited || !purge) continue;
            this.personService.delete(p);
        }
        this.log.info((Object)(count + " account(s) deleted. Change done."));
    }

    public Integer chgValidDate(Date validity, Date current, Boolean validityTest) {
        int count = 0;
        Person search = this.personService.getEmptyPerson();
        search.setValidity(current);
        List persons = this.personService.findByValidityDate(current);
        for (Person person : persons) {
            if (person.getUid().endsWith("@tribu.local")) {
                person.setValidity(validity);
                this.log.info((Object)("Set validity date on " + person.getUid() + " to " + validity.toString()));
                if (!validityTest.booleanValue()) {
                    this.personService.update(person);
                }
                ++count;
                continue;
            }
            this.log.info((Object)(person.getUid() + " is not valid. Validity date not set"));
        }
        this.log.info((Object)(count + " account(s) modified. Change done."));
        return count;
    }

    public Integer chgValidDate(Date validity, List<String> logins, Boolean validityTest) {
        int count = 0;
        for (String login : logins) {
            Person person = this.personService.getEmptyPerson();
            Name dn = person.buildDn(login);
            if ((person = this.personService.getPersonNoCache(dn)) != null && person.getUid().endsWith("@tribu.local")) {
                this.log.info((Object)("Current validity date on " + login + " is " + person.getValidity().toString()));
                person.setValidity(validity);
                this.log.info((Object)("Set validity date on " + login + " to " + validity.toString()));
                if (!validityTest.booleanValue()) {
                    this.personService.update(person);
                }
                ++count;
                continue;
            }
            this.log.info((Object)(login + " is not valid. Validity date not set"));
        }
        this.log.info((Object)(count + " account(s) modified. Change done."));
        return count;
    }
}

