/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.integrity.service;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.core.cms.CMSException;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class UpdateWorkspaceCommand
implements INuxeoCommand {
    private final String workspaceId;
    private final String user;
    private final boolean attach;

    public UpdateWorkspaceCommand(String workspaceId, String user, boolean attach) {
        this.workspaceId = workspaceId;
        this.user = user;
        this.attach = attach;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        DocumentService documentService = (DocumentService)nuxeoSession.getAdapter(DocumentService.class);
        Document workspace = this.getWorkspace(nuxeoSession);
        PropertyList members = workspace.getProperties().getList("ttcs:spaceMembers");
        PropertyMap properties = new PropertyMap();
        properties.set("ttcs:spaceMembers", this.generateUpdatedMembersJSON(members));
        documentService.update((DocRef)workspace, properties);
        return null;
    }

    protected Document getWorkspace(Session nuxeoSession) throws Exception {
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM Document WHERE ");
        query.append("ecm:primaryType = 'Workspace' ");
        query.append("AND webc:url = '").append(this.workspaceId).append("' ");
        OperationRequest request = nuxeoSession.newRequest("Document.Query");
        request.setHeader("X-NXDocumentProperties", "dublincore, toutatice, toutatice_space");
        request.set("query", (Object)query.toString());
        Documents documents = (Documents)request.execute();
        if (documents.size() != 1) {
            throw new CMSException(3);
        }
        Document workspace = documents.get(0);
        return workspace;
    }

    protected String generateUpdatedMembersJSON(PropertyList members) {
        JSONArray array = new JSONArray();
        for (int i = 0; i < members.size(); ++i) {
            PropertyMap member = members.getMap(i);
            String login = member.getString("login");
            if (StringUtils.equals((String)this.user, (String)login)) continue;
            JSONObject object = new JSONObject();
            for (Map.Entry entry : member.getMap().entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                object.put((Object)key, value);
            }
            array.add((Object)object);
        }
        if (this.attach) {
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SS'Z'");
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            JSONObject object = new JSONObject();
            object.put((Object)"login", (Object)this.user);
            object.put((Object)"joinedDate", (Object)dateFormat.format(new Date()));
            array.add((Object)object);
        }
        return array.toString();
    }

    public String getId() {
        return null;
    }
}

