/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.integrity.service;

import fr.gouv.education.foad.integrity.service.GetProceduresInstancesCommand;
import fr.gouv.education.foad.integrity.service.GetWorkspaceCommand;
import fr.gouv.education.foad.integrity.service.GetWorkspacesNotInVersionCommand;
import fr.gouv.education.foad.integrity.service.IntegrityService;
import fr.gouv.education.foad.integrity.service.MigrationCommand;
import fr.gouv.education.foad.integrity.service.UpdateWorkspaceCommand;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.services.NuxeoCommandContext;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import javax.naming.Name;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyList;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.directory.v2.model.CollabProfile;
import org.osivia.directory.v2.model.ext.WorkspaceGroupType;
import org.osivia.directory.v2.service.PersonUpdateService;
import org.osivia.directory.v2.service.WorkspaceService;
import org.osivia.portal.api.cache.services.CacheInfo;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.services.workspace.portlet.model.Invitation;
import org.osivia.services.workspace.portlet.repository.MemberManagementRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class IntegrityServiceImpl
implements IntegrityService {
    private Log log = LogFactory.getLog((String)"org.osivia.directory.v2");
    @Autowired
    private WorkspaceService wsService;
    @Autowired
    private PersonUpdateService personService;
    @Autowired
    private MemberManagementRepository memberRepo;
    @Autowired
    private IBundleFactory bundleFactory;
    @Autowired
    private INotificationsService notificationService;

    public void checkIntegrity(PortalControllerContext portalControllerContext, boolean repare) throws PortletException {
        NuxeoController nuxeoController = this.getNuxeoController(portalControllerContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_NONE);
        nuxeoController.setAsynchronousCommand(false);
        CollabProfile profile = this.wsService.getEmptyProfile();
        profile.setType(WorkspaceGroupType.space_group);
        List workspaces = this.wsService.findByCriteria(profile);
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        for (CollabProfile workspace : workspaces) {
            String workspaceId = workspace.getWorkspaceId();
            Document workspaceDoc = (Document)nuxeoController.executeNuxeoCommand((INuxeoCommand)new GetWorkspaceCommand(workspaceId));
            try {
                if (workspaceDoc != null) {
                    PropertyList map = workspaceDoc.getProperties().getList("ttcs:spaceMembers");
                    int membersNx = 0;
                    int membersLdap = workspace.getUniqueMember().size();
                    if (map != null) {
                        membersNx = map.size();
                    }
                    String title = workspaceDoc.getString("dc:title");
                    if (membersLdap <= membersNx) continue;
                    Date created = workspaceDoc.getDate("dc:created");
                    this.log.error((Object)(title + " (" + workspaceId + ") cr\u00e9\u00e9 le " + sdf.format(created) + " compte " + membersNx + " membres au lieu de " + membersLdap));
                    ArrayList<String> memberLogins = new ArrayList<String>();
                    for (Object element : map.list()) {
                        PropertyMap pmap = (PropertyMap)element;
                        memberLogins.add(pmap.getString("login"));
                    }
                    for (Name uniqueMember : workspace.getUniqueMember()) {
                        String uid = uniqueMember.get(uniqueMember.size() - 1);
                        uid = uid.replace("uid=", "");
                        this.log.error((Object)(uid + " est manquant et sera ajout\u00e9 \u00e0 l'espace " + title));
                        if (memberLogins.contains(uid) || !repare) continue;
                        nuxeoController.executeNuxeoCommand((INuxeoCommand)new UpdateWorkspaceCommand(workspaceId, uid, true));
                    }
                    continue;
                }
                this.log.error((Object)("Workspace " + workspaceId + " introuvable dans Nuxeo !"));
            }
            catch (Exception e) {
                this.log.error((Object)("Exception sur le workspace " + workspaceId), (Throwable)e);
            }
        }
    }

    private NuxeoController getNuxeoController(PortalControllerContext portalControllerContext) {
        PortletRequest request = portalControllerContext.getRequest();
        PortletResponse response = portalControllerContext.getResponse();
        PortletContext portletContext = portalControllerContext.getPortletCtx();
        return new NuxeoController(request, response, portletContext);
    }

    public void purgeAllUsers(PortalControllerContext portalControllerContext, Boolean test) throws PortletException {
        Person search = this.personService.getEmptyPerson();
        List persons = this.personService.findByNoConnectionDate(search);
        ArrayList<String> logins = new ArrayList<String>();
        for (Person p : persons) {
            logins.add(p.getUid());
        }
        int count = this.purgeUsers(portalControllerContext, logins, test);
        while (!test.booleanValue() && count > 0) {
            persons = this.personService.findByNoConnectionDate(search);
            logins = new ArrayList();
            for (Person p : persons) {
                logins.add(p.getUid());
            }
            count = this.purgeUsers(portalControllerContext, logins, test);
        }
    }

    public int purgeUsers(PortalControllerContext portalControllerContext, List<String> logins, Boolean test) throws PortletException {
        int count = 0;
        int errCount = 0;
        NuxeoController controller = new NuxeoController(portalControllerContext);
        Date referenceDate = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(referenceDate);
        c.add(2, -2);
        referenceDate = c.getTime();
        for (String login : logins) {
            try {
                Person p = this.personService.getEmptyPerson();
                Name dn = p.buildDn(login);
                p = this.personService.getPersonNoCache(dn);
                if (p == null) {
                    this.log.warn((Object)("User " + login + " not found"));
                    ++errCount;
                    continue;
                }
                if (p.getLastConnection() != null) {
                    this.log.warn((Object)("User " + p.getUid() + " has a connection date " + p.getLastConnection()));
                    ++errCount;
                    continue;
                }
                boolean recentlyInvited = false;
                Documents invitations = (Documents)controller.executeNuxeoCommand((INuxeoCommand)new GetProceduresInstancesCommand("invitation", "invitation", p.getUid()));
                if (invitations.size() > 0) {
                    ArrayList<Invitation> form = new ArrayList<Invitation>();
                    for (Document invitation : invitations) {
                        Date modified = invitation.getDate("dc:modified");
                        PropertyMap variables = invitation.getProperties().getMap("pi:globalVariablesValues");
                        String workspaceId = variables.get("workspaceId").toString();
                        if (modified.before(referenceDate)) {
                            Invitation invit = new Invitation(p);
                            invit.setDocument(invitation);
                            invit.setDeleted(true);
                            form.add(invit);
                            this.log.info((Object)("Remove invitation for " + p.getUid() + " on " + workspaceId));
                            continue;
                        }
                        this.log.warn((Object)("Cannot remove invitation for " + p.getUid() + " on " + workspaceId + " (recently modified)"));
                        recentlyInvited = true;
                        ++errCount;
                    }
                    if (!recentlyInvited && !test.booleanValue()) {
                        this.memberRepo.updateInvitations(portalControllerContext, form);
                    }
                }
                if (recentlyInvited || test.booleanValue()) continue;
                this.personService.delete(p);
                ++count;
            }
            catch (Exception e) {
                this.log.warn((Object)("Remove " + login + " failed, caused by : " + e.getMessage()));
                ++errCount;
            }
        }
        this.log.info((Object)(count + " account(s) deleted. " + errCount + " account(s) skipped. Change done."));
        Bundle bundle = this.bundleFactory.getBundle(null);
        this.notificationService.addSimpleNotification(portalControllerContext, bundle.getString("PURGE_LOGINS_STATUS", new Object[]{count, errCount}), NotificationsType.ERROR);
        return count;
    }

    public void chgValidDate(PortalControllerContext portalControllerContext, Date validity, Date current, Boolean validityTest) {
        int count = 0;
        int errCount = 0;
        Person search = this.personService.getEmptyPerson();
        search.setValidity(current);
        List persons = this.personService.findByValidityDate(current);
        for (Person person : persons) {
            if (person.getUid().endsWith("@tribu.local")) {
                person.setValidity(validity);
                this.log.info((Object)("Set validity date on " + person.getUid() + " to " + validity.toString()));
                if (!validityTest.booleanValue()) {
                    this.personService.update(person);
                }
                ++count;
                continue;
            }
            this.log.warn((Object)(person.getUid() + " is not valid. Validity date not set"));
        }
        this.log.info((Object)(count + " account(s) modified. Change done."));
        Bundle bundle = this.bundleFactory.getBundle(null);
        this.notificationService.addSimpleNotification(portalControllerContext, bundle.getString("VALIDITY_MODIF_OK", new Object[]{count, errCount}), NotificationsType.SUCCESS);
    }

    public void chgValidDate(PortalControllerContext portalControllerContext, Date validity, List<String> logins, Boolean validityTest) {
        int count = 0;
        int errCount = 0;
        for (String login : logins) {
            Person person = this.personService.getEmptyPerson();
            Name dn = person.buildDn(login);
            if ((person = this.personService.getPersonNoCache(dn)) != null && person.getUid().endsWith("@tribu.local")) {
                this.log.info((Object)("Current validity date on " + login + " is " + person.getValidity().toString()));
                person.setValidity(validity);
                this.log.info((Object)("Set validity date on " + login + " to " + validity.toString()));
                if (!validityTest.booleanValue()) {
                    this.personService.update(person);
                }
                ++count;
                continue;
            }
            this.log.warn((Object)(login + " is not valid. Validity date not set"));
            ++errCount;
        }
        this.log.info((Object)(count + " account(s) modified. Change done."));
        Bundle bundle = this.bundleFactory.getBundle(null);
        this.notificationService.addSimpleNotification(portalControllerContext, bundle.getString("VALIDITY_MODIF_OK", new Object[]{count, errCount}), NotificationsType.SUCCESS);
    }

    public Integer purgeInvit(PortalControllerContext portalControllerContext, boolean test) throws PortletException {
        Integer count = 0;
        NuxeoController controller = new NuxeoController(portalControllerContext);
        Date referenceDate = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(referenceDate);
        c.add(2, -2);
        referenceDate = c.getTime();
        Documents invitations = (Documents)controller.executeNuxeoCommand((INuxeoCommand)new GetProceduresInstancesCommand("invitation", "invitation", referenceDate));
        if (invitations.size() > 0) {
            ArrayList<Invitation> form = new ArrayList<Invitation>();
            for (Document invitation : invitations) {
                Date modified = invitation.getDate("dc:modified");
                PropertyMap variables = invitation.getProperties().getMap("pi:globalVariablesValues");
                String workspaceId = variables.get("workspaceId").toString();
                String uid = variables.get("uid").toString();
                Invitation invit = new Invitation(uid);
                invit.setDocument(invitation);
                invit.setDeleted(true);
                form.add(invit);
                Integer n = count;
                Integer n2 = count = Integer.valueOf(count + 1);
                this.log.info((Object)("Remove invitation for " + uid + " on " + workspaceId + " created on " + modified));
            }
            if (!test) {
                this.memberRepo.updateInvitations(portalControllerContext, form);
            }
        }
        this.log.info((Object)(count + " invitations removed."));
        return count;
    }

    public void purgeAllInvit(PortalControllerContext portalControllerContext) throws PortletException {
        Integer totalPurgeCount = 0;
        Integer purgeCount = this.purgeInvit(portalControllerContext, Boolean.FALSE.booleanValue());
        totalPurgeCount = totalPurgeCount + purgeCount;
        while (purgeCount == Integer.parseInt("200")) {
            purgeCount = this.purgeInvit(portalControllerContext, Boolean.FALSE.booleanValue());
            totalPurgeCount = totalPurgeCount + purgeCount;
        }
        this.log.info((Object)(totalPurgeCount + " invitations removed. Change done."));
        Bundle bundle = this.bundleFactory.getBundle(null);
        this.notificationService.addSimpleNotification(portalControllerContext, bundle.getString("PURGE_INVITS_STATUS", new Object[]{totalPurgeCount}), NotificationsType.SUCCESS);
    }

    public void updateWks(PortalControllerContext portalControllerContext) {
        NuxeoController nuxeoController = new NuxeoController(portalControllerContext);
        nuxeoController.setAuthType(NuxeoCommandContext.AUTH_TYPE_SUPERUSER);
        nuxeoController.setCacheType(CacheInfo.CACHE_SCOPE_NONE);
        nuxeoController.setAsynchronousCommand(false);
        Documents workspaces = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)new GetWorkspacesNotInVersionCommand("4.4.16"));
        for (Document workspace : workspaces) {
            nuxeoController.executeNuxeoCommand((INuxeoCommand)new MigrationCommand(workspace));
        }
    }
}

