/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.integrity.service;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyMap;

public class MigrationCommand
implements INuxeoCommand {
    private Log log = LogFactory.getLog((String)"org.osivia.directory.v2");
    private Document workspace;

    public MigrationCommand(Document workspace) {
        this.workspace = workspace;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        DocumentService documentService = (DocumentService)nuxeoSession.getAdapter(DocumentService.class);
        String pageTemplate = this.workspace.getProperties().getString("ttc:pageTemplate");
        if (!"/default/templates/workspace-simple".equals(pageTemplate)) {
            this.createLastModifStaple(documentService);
        }
        this.migratePictureBooks(documentService);
        this.log.info((Object)("Migration / execute - " + this.workspace.getTitle() + " (" + this.workspace.getPath() + ")"));
        documentService.setProperty((DocRef)this.workspace, "ttc:pageTemplate", null);
        documentService.setProperty((DocRef)this.workspace, "ttc:modelVersion", "4.4.16");
        return null;
    }

    private void migratePictureBooks(DocumentService documentService) throws Exception {
        Documents pictureBooks = documentService.query("SELECT * FROM PictureBook WHERE ecm:path STARTSWITH '" + this.workspace.getPath() + "'");
        ArrayList<Document> pbooksToRemove = new ArrayList<Document>();
        for (Document document : pictureBooks) {
            Documents pictures = documentService.query("SELECT * FROM Picture WHERE ecm:path STARTSWITH '" + document.getPath() + "' ");
            if (pictures.size() > 0) {
                int lastIndexOf = document.getPath().lastIndexOf("/");
                String parentPath = document.getPath().substring(0, lastIndexOf);
                Document parent = documentService.getDocument(parentPath);
                if (parent.getType().equals("Workspace") || parent.getType().equals("Room")) {
                    this.log.info((Object)("Migration / migratePictureBooks - " + document.getTitle() + " (" + document.getPath() + ")"));
                    String pbookWebid = document.getProperties().getString("ttc:webid");
                    documentService.setProperty((DocRef)document, "ttc:webid", pbookWebid + "_old");
                    PropertyMap properties = new PropertyMap();
                    properties.set("dc:title", document.getTitle());
                    properties.set("ttc:showInMenu", Boolean.valueOf(true));
                    properties.set("ttc:webid", pbookWebid);
                    Document folderDest = documentService.createDocument((DocRef)parent, "Folder", pbookWebid, properties);
                    for (Document picture : pictures) {
                        documentService.move((DocRef)picture, (DocRef)folderDest);
                    }
                } else {
                    this.log.warn((Object)("Migration / skip sub-picturebook - " + document.getTitle() + " (" + document.getPath() + ")"));
                }
            } else {
                this.log.warn((Object)("Migration / skip empty picturebook - " + document.getTitle() + " (" + document.getPath() + ")"));
            }
            pbooksToRemove.add(document);
        }
        for (DocRef docRef : pbooksToRemove) {
            documentService.remove(docRef);
        }
    }

    private void createLastModifStaple(DocumentService documentService) throws Exception {
        String shortname = this.workspace.getString("webc:url");
        String webIdPrefix = "workspace_" + shortname + "_";
        String type = "Staple";
        String webId = webIdPrefix + StringUtils.lowerCase((String)"last_modifications");
        Documents query = documentService.query("SELECT * FROM Document WHERE ttc:webid = '" + webId + "'");
        if (query.size() == 0) {
            this.log.info((Object)("Migration / createLastModifStaple - " + this.workspace.getTitle() + " (" + this.workspace.getPath() + ")"));
            PropertyMap properties = new PropertyMap();
            properties.set("dc:title", "Derni\u00e8res modifications");
            properties.set("ttc:showInMenu", Boolean.valueOf(true));
            properties.set("ttc:webid", webId);
            documentService.createDocument((DocRef)this.workspace, type, "dernieres-modifications", properties);
        } else {
            this.log.warn((Object)("Migration / createLastModifStaple - " + this.workspace.getTitle() + " (" + this.workspace.getPath() + ") already exists."));
        }
    }

    public String getId() {
        return null;
    }
}

