/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.bns.batch;

import fr.gouv.education.foad.bns.controller.BnsImportForm;
import fr.toutatice.portail.cms.nuxeo.api.batch.NuxeoBatch;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.naming.ldap.LdapName;
import javax.portlet.PortletContext;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osivia.directory.v2.service.PersonUpdateService;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.directory.v2.model.Person;
import org.springframework.ldap.support.LdapNameBuilder;

public class BnsImportBatch
extends NuxeoBatch {
    private Log log = LogFactory.getLog((String)"org.osivia.directory.v2");
    private static PortletContext portletContext;
    private BnsImportForm form;
    private PersonUpdateService personService = (PersonUpdateService)DirServiceFactory.getService(PersonUpdateService.class);
    private LdapName profile;
    private static final String MAIL_REGEX = "^[_A-Za-z0-9-\\+]+(\\.[_A-Za-z0-9-]+)*@[A-Za-z0-9-]+(\\.[A-Za-z0-9]+)*(\\.[A-Za-z]{2,})$";
    private final Pattern mailPattern;
    private CSVPrinter rejectsPrinter;

    public BnsImportBatch(BnsImportForm form) {
        super(form.getTemporaryFile().getName());
        this.form = form;
        this.profile = LdapNameBuilder.newInstance((String)System.getProperty("ldap.base")).add("ou=groups").add("ou=profiles").add("cn=" + form.getProfile().getProfileName()).build();
        this.mailPattern = Pattern.compile(MAIL_REGEX);
    }

    public String getJobScheduling() {
        return null;
    }

    public void execute(Map<String, Object> parameters) throws PortalException {
        this.log.warn((Object)("Fire extraction of : " + this.form.getTemporaryFile().getAbsolutePath()));
        Person search = this.personService.getEmptyPerson();
        search.getProfiles().add(this.profile);
        List findByCriteria = this.personService.findByCriteria(search);
        while (!findByCriteria.isEmpty()) {
            for (Person personToClean : findByCriteria) {
                this.log.info((Object)("Remove " + personToClean.getUid() + " from " + this.form.getProfile().getProfileName()));
                personToClean.getProfiles().remove(this.profile);
                this.personService.update(personToClean);
            }
            findByCriteria = this.personService.findByCriteria(search);
        }
        try {
            CSVParser parser = CSVParser.parse((File)this.form.getTemporaryFile(), (Charset)StandardCharsets.UTF_8, (CSVFormat)CSVFormat.EXCEL);
            boolean hasRejects = false;
            for (CSVRecord record : parser) {
                String uid = record.get(0);
                uid = StringUtils.lowerCase((String)uid);
                if (!StringUtils.isNotBlank((String)(uid = uid.trim()))) continue;
                Person person = this.personService.getPerson(uid);
                if (person != null) {
                    this.log.info((Object)("Import " + record.get(0) + " to " + this.form.getProfile().getProfileName()));
                    person.getProfiles().add(this.profile);
                    this.personService.update(person);
                    continue;
                }
                Matcher matcher = this.mailPattern.matcher(uid);
                if (!matcher.matches()) {
                    this.log.info((Object)("Reject " + record.get(0)));
                    this.rejectsPrinter = this.getRejectPrinter();
                    this.rejectsPrinter.printRecord(new Object[]{uid});
                    hasRejects = true;
                    continue;
                }
                this.log.info((Object)("Create " + record.get(0) + " and add to " + this.form.getProfile().getProfileName()));
                person = this.personService.getEmptyPerson();
                person.setUid(uid);
                person.setMail(uid);
                person.setSn(uid);
                person.setGivenName(uid);
                person.setCn(uid);
                person.setDisplayName(uid);
                person.getProfiles().add(this.profile);
                this.personService.create(person);
            }
            if (hasRejects) {
                this.rejectsPrinter.flush();
                this.rejectsPrinter.close();
            }
        }
        catch (IOException e) {
            throw new PortalException((Exception)e);
        }
    }

    private CSVPrinter getRejectPrinter() throws IOException {
        if (this.rejectsPrinter == null) {
            File rejects = new File(this.form.getTemporaryFile().getAbsolutePath() + "_rejects");
            rejects.createNewFile();
            this.rejectsPrinter = new CSVPrinter((Appendable)new FileWriter(rejects), CSVFormat.EXCEL);
        }
        return this.rejectsPrinter;
    }

    public void setPortletContext(PortletContext portletContext) {
        BnsImportBatch.portletContext = portletContext;
    }

    protected PortletContext getPortletContext() {
        return portletContext;
    }
}

