/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.accounts.controller;

import fr.gouv.education.foad.accounts.controller.AccountsForm;
import fr.toutatice.portail.cms.nuxeo.api.CMSPortlet;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.naming.Name;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletConfig;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.apache.commons.lang.StringUtils;
import org.osivia.directory.v2.model.CollabProfile;
import org.osivia.directory.v2.model.ext.WorkspaceGroupType;
import org.osivia.directory.v2.model.ext.WorkspaceMember;
import org.osivia.directory.v2.service.PersonUpdateService;
import org.osivia.directory.v2.service.WorkspaceService;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.v2.model.Person;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.notifications.NotificationsType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;
import org.springframework.web.portlet.context.PortletConfigAware;
import org.springframework.web.portlet.context.PortletContextAware;

@Controller
@RequestMapping(value={"VIEW"})
public class AccountsController
extends CMSPortlet
implements PortletConfigAware,
PortletContextAware {
    private PortletConfig portletConfig;
    private PortletContext portletContext;
    @Autowired
    private WorkspaceService workspaceService;
    @Autowired
    private PersonUpdateService personService;

    @PostConstruct
    public void postConstruct() throws PortletException {
        super.init(this.portletConfig);
    }

    @PreDestroy
    public void preDestroy() {
        super.destroy();
    }

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response) {
        return "view";
    }

    @ModelAttribute(value="form")
    public AccountsForm getForm() {
        return new AccountsForm();
    }

    @ActionMapping(value="migrateAccount")
    public void migrateAccount(@ModelAttribute(value="form") AccountsForm form, ActionRequest request, ActionResponse response) {
        PortalControllerContext pcc = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        Bundle bundle = this.getBundleFactory().getBundle(null);
        String oldAccountUid = form.getOldAccountUid();
        Person oldPerson = this.personService.getPerson(oldAccountUid);
        if (oldPerson == null) {
            this.getNotificationsService().addSimpleNotification(pcc, bundle.getString("account.mig.errornotfound"), NotificationsType.ERROR);
        } else {
            String str = form.getNewAccountUids();
            String[] split = str.split(";");
            for (int i = 0; i < split.length; ++i) {
                String uid = StringUtils.trimToNull((String)split[i]);
                boolean newAccount = false;
                Person newPerson = this.personService.getPerson(uid);
                if (newPerson == null) {
                    newPerson = this.personService.getEmptyPerson();
                    newPerson.setUid(uid);
                    newPerson.setMail(uid);
                    newPerson.setSn(oldPerson.getSn());
                    newPerson.setGivenName(oldPerson.getGivenName());
                    newPerson.setCn(oldPerson.getCn());
                    newPerson.setDisplayName(oldPerson.getDisplayName());
                    this.personService.create(newPerson);
                    newAccount = true;
                }
                CollabProfile profile = this.workspaceService.getEmptyProfile();
                ArrayList<Name> list = new ArrayList<Name>();
                list.add(oldPerson.getDn());
                profile.setUniqueMember(list);
                profile.setType(WorkspaceGroupType.space_group);
                List workspaces = this.workspaceService.findByCriteria(profile);
                Integer spaceCount = 0;
                Integer errCount = 0;
                Integer localGroups = 0;
                for (CollabProfile workspaceProfile : workspaces) {
                    WorkspaceMember member = this.workspaceService.getMember(workspaceProfile.getWorkspaceId(), oldAccountUid);
                    try {
                        this.workspaceService.addOrModifyMember(workspaceProfile.getWorkspaceId(), newPerson.getDn(), member.getRole());
                        for (CollabProfile localGroup : member.getLocalGroups()) {
                            this.workspaceService.addMemberToLocalGroup(workspaceProfile.getWorkspaceId(), localGroup.getDn(), newPerson.getDn());
                            localGroups = localGroups + 1;
                        }
                    }
                    catch (Exception e) {
                        errCount = errCount + 1;
                    }
                    spaceCount = spaceCount + 1;
                }
                String message = uid + " : ";
                if (newAccount) {
                    message = bundle.getString("account.mig.newAccount", new Object[]{uid});
                }
                if (errCount > 0) {
                    this.getNotificationsService().addSimpleNotification(pcc, message.concat(bundle.getString("account.mig.warning", new Object[]{spaceCount, errCount})), NotificationsType.WARNING);
                    continue;
                }
                this.getNotificationsService().addSimpleNotification(pcc, message.concat(bundle.getString("account.mig.success", new Object[]{spaceCount, localGroups})), NotificationsType.SUCCESS);
            }
        }
    }

    public void setPortletContext(PortletContext portletContext) {
        this.portletContext = portletContext;
    }

    public void setPortletConfig(PortletConfig portletConfig) {
        this.portletConfig = portletConfig;
    }
}

