/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.integrity.batch;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;

public class GetWorkspacesInTrashCommand
implements INuxeoCommand {
    public static final int PAGE_SIZE = 1000;
    private int currentPageIndex;
    private Integer delaiJoursEspaceEnCorbeille;
    private String path;

    public GetWorkspacesInTrashCommand(int currentPageIndex, Integer delaiJoursEspaceEnCorbeille, String path) {
        this.currentPageIndex = currentPageIndex;
        this.delaiJoursEspaceEnCorbeille = delaiJoursEspaceEnCorbeille;
        this.path = path;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        SimpleDateFormat sdf = new SimpleDateFormat("YYYY-MM-dd");
        Date referenceDate = new Date();
        Calendar c = Calendar.getInstance();
        c.setTime(referenceDate);
        c.add(6, Math.negateExact(this.delaiJoursEspaceEnCorbeille));
        referenceDate = c.getTime();
        OperationRequest request = nuxeoSession.newRequest("Document.QueryES");
        request.set("query", (Object)("SELECT * FROM DOcument WHERE ecm:primaryType = 'Workspace' AND ecm:path STARTSWITH '" + this.path + "'  AND dc:modified < DATE '" + sdf.format(referenceDate) + "' AND ecm:currentLifeCycleState = 'deleted'"));
        request.set("pageSize", (Object)1000);
        request.set("currentPageIndex", (Object)this.currentPageIndex);
        request.set("X-NXDocumentProperties", (Object)"*");
        return nuxeoSession.execute(request);
    }

    public String getId() {
        return this.getClass().getSimpleName() + " page:" + this.currentPageIndex + " " + new Date().getTime();
    }
}

