/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.integrity.batch;

import com.sun.mail.smtp.SMTPTransport;
import fr.gouv.education.foad.integrity.batch.DeleteWorkspaceCommand;
import fr.gouv.education.foad.integrity.batch.GetAllWorkspacesCommand;
import fr.gouv.education.foad.integrity.batch.GetContentInWorkspace;
import fr.gouv.education.foad.integrity.batch.GetWorkspacesInTrashCommand;
import fr.gouv.education.foad.integrity.batch.GetWorkspacesNoVisitCommand;
import fr.gouv.education.foad.integrity.batch.PutWorkspaceInTrashCommand;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.batch.NuxeoBatch;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.portlet.PortletContext;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PaginableDocuments;
import org.osivia.directory.v2.model.ext.WorkspaceMember;
import org.osivia.directory.v2.model.ext.WorkspaceRole;
import org.osivia.directory.v2.service.WorkspaceService;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.directory.v2.DirServiceFactory;

public class SupprEspacesVidesBatch
extends NuxeoBatch {
    private static PortletContext portletContext;
    private Log log = LogFactory.getLog((String)"batch");
    private WorkspaceService workspaceService = (WorkspaceService)DirServiceFactory.getService(WorkspaceService.class);
    private Integer delaiJoursEspaceVide;
    private Integer delaiJoursEspaceSansVisite;
    private Integer delaiJoursEspaceEnCorbeille;
    private Boolean notification;
    private String path;
    private boolean testMode;

    public SupprEspacesVidesBatch() {
        String propDelaiJoursEspaceVide = System.getProperty("foad.purgeespaces.delaiJoursEspaceVide");
        this.delaiJoursEspaceVide = StringUtils.isNotBlank((String)propDelaiJoursEspaceVide) ? Integer.valueOf(Integer.parseInt(propDelaiJoursEspaceVide)) : Integer.valueOf(60);
        String propDelaiJoursEspaceSansVisite = System.getProperty("foad.purgeespaces.delaiJoursEspaceSansVisite");
        this.delaiJoursEspaceSansVisite = StringUtils.isNotBlank((String)propDelaiJoursEspaceSansVisite) ? Integer.valueOf(Integer.parseInt(propDelaiJoursEspaceSansVisite)) : Integer.valueOf(300);
        String propDelaiJoursEspaceEnCorbeille = System.getProperty("foad.purgeespaces.delaiJoursEspaceEnCorbeille");
        this.delaiJoursEspaceEnCorbeille = StringUtils.isNotBlank((String)propDelaiJoursEspaceEnCorbeille) ? Integer.valueOf(Integer.parseInt(propDelaiJoursEspaceEnCorbeille)) : Integer.valueOf(60);
        String propNotification = System.getProperty("foad.purgeespaces.notification");
        this.notification = StringUtils.isNotBlank((String)propNotification) ? Boolean.valueOf(BooleanUtils.toBoolean((String)propNotification)) : Boolean.valueOf(true);
        String propTestmode = System.getProperty("foad.purgeespaces.testmode");
        this.testMode = StringUtils.isNotBlank((String)propTestmode) ? BooleanUtils.toBoolean((String)propTestmode) : false;
        String propPath = System.getProperty("foad.purgeespaces.path");
        this.path = StringUtils.isNotBlank((String)propPath) ? propPath : "/default-domain/workspaces/";
    }

    public PortletContext getPortletContext() {
        return portletContext;
    }

    public static void setPortletContext(PortletContext portletContext) {
        SupprEspacesVidesBatch.portletContext = portletContext;
    }

    public String getJobScheduling() {
        String cron = System.getProperty("foad.purgeespaces.cron");
        if (StringUtils.isNotBlank((String)cron)) {
            return cron;
        }
        return "0 0 9 ? * SAT";
    }

    public void execute(Map<String, Object> parameters) throws PortalException {
        if (this.delaiJoursEspaceVide > 0) {
            this.supprEspacesVides();
        }
        if (this.delaiJoursEspaceSansVisite > 0) {
            this.corbeilleEspacesSansVisite();
        }
        if (this.delaiJoursEspaceEnCorbeille > 0) {
            this.vidageCorbeille();
        }
    }

    private void supprEspacesVides() {
        NuxeoController nuxeoController = this.getNuxeoController();
        int pageIndex = 0;
        int pageCount = 1;
        ArrayList<Document> spacesToRemove = new ArrayList<Document>();
        do {
            GetAllWorkspacesCommand command = new GetAllWorkspacesCommand(pageIndex, this.delaiJoursEspaceVide, this.path);
            PaginableDocuments workspaces = (PaginableDocuments)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
            pageCount = workspaces.getPageCount();
            this.log.info((Object)("=== Suppression des espaces vides, page " + pageIndex + "/" + pageCount));
            for (Document workspace : workspaces.list()) {
                GetContentInWorkspace contentCmd = new GetContentInWorkspace(workspace);
                Documents documents = (Documents)nuxeoController.executeNuxeoCommand((INuxeoCommand)contentCmd);
                if (documents.size() != 0) continue;
                this.log.info((Object)("L'Espace " + workspace.getTitle() + " est vide."));
                spacesToRemove.add(workspace);
            }
        } while (++pageIndex < pageCount);
        if (!this.testMode) {
            for (Document spaceToRemove : spacesToRemove) {
                String workspaceId = spaceToRemove.getString("webc:url");
                this.log.info((Object)("Suppression d\u00e9finitive de " + spaceToRemove.getTitle() + " (" + workspaceId + ")"));
                this.workspaceService.delete(workspaceId);
                DeleteWorkspaceCommand deleteCommand = new DeleteWorkspaceCommand(spaceToRemove);
                nuxeoController.executeNuxeoCommand((INuxeoCommand)deleteCommand);
            }
        }
    }

    private void corbeilleEspacesSansVisite() {
        NuxeoController nuxeoController = this.getNuxeoController();
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
        int pageIndex = 0;
        int pageCount = 1;
        ArrayList<Document> spacesToPutInTrash = new ArrayList<Document>();
        do {
            GetWorkspacesNoVisitCommand command = new GetWorkspacesNoVisitCommand(pageIndex, this.delaiJoursEspaceSansVisite, this.path);
            PaginableDocuments workspaces = (PaginableDocuments)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
            pageCount = workspaces.getPageCount();
            this.log.info((Object)("=== Mise en corbeille des espaces sans viste, page " + pageIndex + "/" + pageCount));
            for (Document workspace : workspaces.list()) {
                Date lastVisit = workspace.getDate("stats:lastUpdate");
                if (lastVisit == null) {
                    lastVisit = workspace.getDate("dc:created");
                }
                this.log.info((Object)("L'espace " + workspace.getTitle() + " n'a pas \u00e9t\u00e9 visit\u00e9 depuis le " + sdf.format(lastVisit)));
                spacesToPutInTrash.add(workspace);
            }
        } while (++pageIndex < pageCount);
        StringBuilder reporting = new StringBuilder();
        if (!this.testMode) {
            for (Document spaceToPutInTrash : spacesToPutInTrash) {
                this.log.info((Object)("Mise en corbeille de " + spaceToPutInTrash.getTitle()));
                String workspaceId = spaceToPutInTrash.getString("webc:url");
                ArrayList<String> owners = new ArrayList<String>();
                List allMembers = this.workspaceService.getAllMembers(workspaceId);
                for (WorkspaceMember member : allMembers) {
                    if (member.getRole() != WorkspaceRole.OWNER) continue;
                    owners.add(member.getMember().getMail());
                }
                PutWorkspaceInTrashCommand deleteCommand = new PutWorkspaceInTrashCommand(spaceToPutInTrash);
                nuxeoController.executeNuxeoCommand((INuxeoCommand)deleteCommand);
                if (this.notification.booleanValue() && owners.size() > 0) {
                    try {
                        String to = String.join((CharSequence)";", owners);
                        String object = "D\u00e9sactivation de votre espace ".concat(spaceToPutInTrash.getTitle());
                        StringBuilder body = new StringBuilder();
                        body.append("<p>Suite \u00e0 l\u2019inactivit\u00e9 sur votre espace ");
                        body.append(spaceToPutInTrash.getTitle());
                        body.append(" depuis plus de 10 mois, cet espace a \u00e9t\u00e9 mis en corbeille. </p>");
                        body.append("<p>Si vous voulez r\u00e9cup\u00e9rer les documents qui y sont d\u00e9pos\u00e9s, contactez le P\u00f4le FOAD ");
                        body.append("(<a href=\"mailto:pole.foad@ac-toulouse.fr\">pole.foad@ac-toulouse.fr</a>).</p>");
                        this.sendMail(to, object, body);
                        reporting.append("<li>");
                        reporting.append(spaceToPutInTrash.getTitle());
                        reporting.append(" (");
                        reporting.append(owners);
                        reporting.append(")");
                        reporting.append("</li>");
                    }
                    catch (MessagingException e) {
                        this.log.error((Object)("Impossible de notifier les propri\u00e9taires de l'espace " + spaceToPutInTrash.getTitle()), (Throwable)e);
                    }
                    continue;
                }
                this.log.warn((Object)("Les propri\u00e9taires de l'espace " + spaceToPutInTrash.getTitle() + " ne sont pas notifi\u00e9s."));
            }
            if (spacesToPutInTrash.size() > 0) {
                String to = "pole.foad@ac-toulouse.fr";
                String object = "Mise en corbeille d'espaces";
                StringBuilder body = new StringBuilder();
                body.append("<p>Suite \u00e0 l\u2019inactivit\u00e9 sur plusieurs espaces, ils ont \u00e9t\u00e9 d\u00e9plac\u00e9 dans la corbeille administrateur et les propri\u00e9taires ont \u00e9t\u00e9 notifi\u00e9s.</p><ul>");
                body.append((CharSequence)reporting);
                body.append("</ul>");
                try {
                    this.sendMail(to, object, body);
                }
                catch (MessagingException e) {
                    this.log.error((Object)"Impossible de notifier les administrateurs du p\u00f4le", (Throwable)e);
                }
            }
        }
    }

    public void sendMail(String mailToVar, String mailObjectVar, StringBuilder body) throws MessagingException {
        String mailFromVar = System.getProperty("osivia.procedures.default.mail.from");
        String mailReplyToVar = "pole.foad@ac-toulouse.fr";
        Properties properties = System.getProperties();
        String subjectPrefix = properties.getProperty("mail.subject.prefix");
        if (StringUtils.isNotBlank((String)subjectPrefix)) {
            mailObjectVar = "[".concat(subjectPrefix).concat("] ").concat(mailObjectVar);
        }
        Authenticator auth = null;
        Session mailSession = Session.getInstance((Properties)properties, auth);
        MimeMessage message = new MimeMessage(mailSession);
        InternetAddress mailFromAddr = null;
        if (StringUtils.isNotBlank((String)mailFromVar)) {
            mailFromAddr = new InternetAddress(mailFromVar);
        }
        InternetAddress[] mailReplyToAddr = null;
        if (StringUtils.isNotBlank((String)mailReplyToVar)) {
            mailReplyToAddr = InternetAddress.parse((String)mailReplyToVar, (boolean)false);
        }
        InternetAddress[] mailToAddr = InternetAddress.parse((String)mailToVar, (boolean)false);
        message.setFrom((Address)mailFromAddr);
        message.setRecipients(Message.RecipientType.TO, (Address[])mailToAddr);
        message.setSubject(mailObjectVar, "UTF-8");
        MimeMultipart multipart = new MimeMultipart();
        MimeBodyPart htmlPart = new MimeBodyPart();
        htmlPart.setContent((Object)body.toString(), "text/html; charset=UTF-8");
        multipart.addBodyPart((BodyPart)htmlPart);
        message.setContent((Multipart)multipart);
        message.setSentDate(new Date());
        if (mailFromAddr != null) {
            if (mailReplyToAddr == null) {
                InternetAddress[] replyToTab = new InternetAddress[]{mailFromAddr};
                message.setReplyTo((Address[])replyToTab);
            } else {
                message.setReplyTo((Address[])mailReplyToAddr);
            }
        }
        SMTPTransport transport = (SMTPTransport)mailSession.getTransport();
        transport.connect();
        transport.sendMessage((Message)message, message.getAllRecipients());
        transport.close();
    }

    private void vidageCorbeille() {
        NuxeoController nuxeoController = this.getNuxeoController();
        int pageIndex = 0;
        int pageCount = 1;
        ArrayList<Document> spacesToRemove = new ArrayList<Document>();
        do {
            GetWorkspacesInTrashCommand command = new GetWorkspacesInTrashCommand(pageIndex, this.delaiJoursEspaceEnCorbeille, this.path);
            PaginableDocuments workspacesInTrash = (PaginableDocuments)nuxeoController.executeNuxeoCommand((INuxeoCommand)command);
            pageCount = workspacesInTrash.getPageCount();
            this.log.info((Object)("=== Suppression des espaces mis en corbeille, page " + pageIndex + "/" + pageCount));
            for (Document workspaceInTrash : workspacesInTrash.list()) {
                spacesToRemove.add(workspaceInTrash);
                this.log.info((Object)("L'Espace " + workspaceInTrash.getTitle() + " est dans la corbeille administrateur."));
            }
        } while (++pageIndex < pageCount);
        if (!this.testMode) {
            for (Document spaceToRemove : spacesToRemove) {
                String workspaceId = spaceToRemove.getString("webc:url");
                this.log.info((Object)("Suppression d\u00e9finitive de " + spaceToRemove.getTitle() + " (" + workspaceId + ")"));
                this.workspaceService.delete(workspaceId);
                DeleteWorkspaceCommand deleteCommand = new DeleteWorkspaceCommand(spaceToRemove);
                nuxeoController.executeNuxeoCommand((INuxeoCommand)deleteCommand);
            }
        }
    }
}

