/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.room.controller;

import fr.gouv.education.foad.room.controller.RoomMigration;
import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.DocumentSecurityService;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.DocumentPermissions;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.osivia.services.workspace.portlet.model.Permission;

public class TransformRoomCommand
implements INuxeoCommand {
    private Log log = LogFactory.getLog((String)"org.osivia.directory.v2");
    private List<RoomMigration> lrm;

    public TransformRoomCommand(List<RoomMigration> lrm) {
        this.lrm = lrm;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        this.log.info((Object)"===========");
        this.log.info((Object)"D\u00e9but migration,");
        Integer nbRoomsSkipped = 0;
        Integer nbRoomsDone = 0;
        Collections.sort(this.lrm);
        for (RoomMigration rm : this.lrm) {
            Integer n;
            Integer n2;
            this.log.info((Object)("D\u00e9placement de " + rm.getRoom().getTitle() + ")"));
            OperationRequest request = nuxeoSession.newRequest("Document.Query");
            request.set("query", (Object)("SELECT * FROM Document WHERE ecm:uuid <> '" + rm.getRoom().getId() + "' AND ecm:primaryType = 'Room' AND ecm:path STARTSWITH '" + rm.getRoom().getPath() + "' " + " AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState != 'deleted'"));
            Documents innerRooms = (Documents)request.execute();
            if (innerRooms.size() > 0) {
                this.log.error((Object)" Cette salle contient encore des sous-salles.");
                rm.setState(RoomMigration.State.SKIP);
                n2 = nbRoomsSkipped;
                n = nbRoomsSkipped = Integer.valueOf(nbRoomsSkipped + 1);
                continue;
            }
            if (rm.getState() != RoomMigration.State.NEW) {
                this.log.error((Object)" Cette salle avait \u00e9t\u00e9 marqu\u00e9e en erreur et ne sera pas trait\u00e9e.");
                rm.setState(RoomMigration.State.SKIP);
                n2 = nbRoomsSkipped;
                n = nbRoomsSkipped = Integer.valueOf(nbRoomsSkipped + 1);
                continue;
            }
            DocumentService documentService = (DocumentService)nuxeoSession.getAdapter(DocumentService.class);
            String webid = rm.getRoom().getProperties().getString("ttc:webid");
            Boolean showInMenu = rm.getRoom().getProperties().getBoolean("ttc:showInMenu");
            documentService.setProperty((DocRef)rm.getRoom(), "ttc:webid", webid + "_old");
            Document parent = documentService.getParent((DocRef)rm.getRoom());
            request = nuxeoSession.newRequest("Document.QueryES");
            request.set("query", (Object)("SELECT * FROM Document WHERE ecm:primaryType IN ('Folder','Note') AND ecm:parentId = '" + rm.getId() + "' " + " AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState != 'deleted'"));
            Documents rootFolders = (Documents)request.execute();
            Document targetFolder = null;
            this.log.info((Object)(" Cr\u00e9ation d'un dossier " + rm.getRoom().getTitle()));
            targetFolder = documentService.createDocument((DocRef)parent, "Folder", webid);
            documentService.setProperty((DocRef)targetFolder, "ttc:webid", webid);
            documentService.setProperty((DocRef)targetFolder, "dc:title", rm.getRoom().getTitle());
            if (!showInMenu.booleanValue()) {
                documentService.setProperty((DocRef)targetFolder, "ttc:showInMenu", "false");
            }
            rm.setTargetFolder(targetFolder);
            if (!rootFolders.isEmpty()) {
                this.log.info((Object)(" Regroupement des documents dans un dossier " + rm.getRoom().getTitle()));
                for (Document folder : rootFolders) {
                    this.log.info((Object)("  Document " + folder.getTitle()));
                    documentService.move((DocRef)folder, (DocRef)targetFolder);
                }
            }
            for (Document misc : rm.getMiscDocs()) {
                request = nuxeoSession.newRequest("Document.QueryES");
                request.set("query", (Object)("SELECT * FROM Document WHERE ecm:parentId = '" + misc.getId() + "' " + " AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState != 'deleted'"));
                Documents children = (Documents)request.execute();
                if (children.size() > 0) {
                    this.log.info((Object)(" D\u00e9placment de " + misc.getTitle() + " vers l'espace parent "));
                    documentService.move((DocRef)misc, (DocRef)parent);
                    continue;
                }
                this.log.info((Object)(" Suppression de " + misc.getTitle() + " (service vide) "));
            }
            if (rm.getLocalArray() != null && rm.getState() == RoomMigration.State.NEW) {
                this.transformAcls(nuxeoSession, rm);
            }
            this.log.info((Object)(" Suppression de l'ancienne salle " + rm.getRoom().getTitle()));
            nuxeoSession.newRequest("Document.PutDocumentInTrash").set("document", (Object)rm.getRoom().getId()).setHeader("nx_es_sync", "true").execute();
            Integer n3 = nbRoomsDone;
            Integer n4 = nbRoomsDone = Integer.valueOf(nbRoomsDone + 1);
        }
        this.log.info((Object)"Fin migration,");
        this.log.info((Object)("Salles trait\u00e9es : " + nbRoomsDone + ", salles non trait\u00e9es : " + nbRoomsSkipped));
        this.log.info((Object)"===========");
        return null;
    }

    private void transformAcls(Session nuxeoSession, RoomMigration rm) throws Exception {
        this.log.info((Object)"Traitement des ACLs");
        JSONArray localArray = rm.getLocalArray();
        HashMap<String, Permission> permissions = new HashMap<String, Permission>(localArray.size());
        boolean publicEntry = false;
        boolean blockInherit = false;
        for (int i = 0; i < localArray.size(); ++i) {
            JSONObject object = localArray.getJSONObject(i);
            if (object.getBoolean("isGranted")) {
                String name = object.getString("username");
                if ("Everyone".equals(name)) {
                    publicEntry = true;
                    continue;
                }
                boolean group = object.getBoolean("isGroup");
                Permission permission = (Permission)permissions.get(name);
                if (permission == null) {
                    permission = new Permission();
                    permission.setName(name);
                    permission.setValues(new ArrayList());
                    permission.setGroup(group);
                    permissions.put(name, permission);
                }
                permission.getValues().add(object.getString("permission"));
                continue;
            }
            blockInherit = true;
        }
        ArrayList permissionsList = new ArrayList(permissions.values());
        DocumentPermissions dtoPerms = this.toDocumentPermissions(permissionsList);
        DocumentSecurityService securityService = (DocumentSecurityService)nuxeoSession.getAdapter(DocumentSecurityService.class);
        securityService.addPermissions(rm.getTargetFolder(), dtoPerms, "local", blockInherit);
        for (Document misc : rm.getMiscDocs()) {
            securityService.addPermissions(misc, dtoPerms, "local", blockInherit);
        }
    }

    private DocumentPermissions toDocumentPermissions(List<Permission> permissions) {
        DocumentPermissions documentPermissions;
        if (CollectionUtils.isEmpty(permissions)) {
            documentPermissions = new DocumentPermissions(0);
        } else {
            documentPermissions = new DocumentPermissions(permissions.size());
            for (Permission permission : permissions) {
                documentPermissions.setPermissions(permission.getName(), permission.getValues());
            }
        }
        return documentPermissions;
    }

    public String getId() {
        return this.toString();
    }
}

