/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.workspace.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.forms.IFormsService;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.adapters.DocumentService;
import org.nuxeo.ecm.automation.client.model.DocRef;
import org.nuxeo.ecm.automation.client.model.Document;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.nuxeo.ecm.automation.client.model.PropertyMap;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.workspace.portlet.model.InvitationRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class UpdateInvitationRequestsCommand
implements INuxeoCommand {
    @Autowired
    private IFormsService formsService;
    private final PortalControllerContext portalControllerContext;
    private final List<InvitationRequest> invitationRequests;

    public UpdateInvitationRequestsCommand(PortalControllerContext portalControllerContext, List<InvitationRequest> invitationRequests) {
        this.portalControllerContext = portalControllerContext;
        this.invitationRequests = invitationRequests;
    }

    public Object execute(Session nuxeoSession) throws Exception {
        DocumentService documentService = (DocumentService)nuxeoSession.getAdapter(DocumentService.class);
        for (InvitationRequest invitationRequest : this.invitationRequests) {
            Document document = invitationRequest.getDocument();
            if (invitationRequest.isEdited() || invitationRequest.isAccepted()) {
                PropertyMap variables = document.getProperties().getMap("pi:globalVariablesValues");
                variables.set("role", invitationRequest.getRole().getId());
                PropertyMap properties = new PropertyMap();
                properties.set("pi:globalVariablesValues", this.generateVariablesJSON(variables));
                documentService.update((DocRef)document, properties);
            }
            if (invitationRequest.isDeleted()) {
                this.proceed(nuxeoSession, invitationRequest, "actionIdNo");
                continue;
            }
            if (!invitationRequest.isAccepted()) continue;
            this.proceed(nuxeoSession, invitationRequest, "actionIdYes");
        }
        return null;
    }

    private String generateVariablesJSON(PropertyMap variables) {
        JSONArray array = new JSONArray();
        for (Map.Entry entry : variables.getMap().entrySet()) {
            JSONObject object = new JSONObject();
            object.put((Object)"name", entry.getKey());
            object.put((Object)"value", entry.getValue());
            array.add((Object)object);
        }
        return array.toString();
    }

    private void proceed(Session nuxeoSession, InvitationRequest invitationRequest, String action) throws Exception {
        Document task = this.getTask(nuxeoSession, invitationRequest);
        PropertyMap taskVariables = task.getProperties().getMap("nt:task_variables");
        String actionId = taskVariables.getString(action);
        this.formsService.proceed(this.portalControllerContext, task, actionId, null);
    }

    private Document getTask(Session nuxeoSession, InvitationRequest invitationRequest) throws Exception {
        Document requestDocument = invitationRequest.getDocument();
        PropertyMap properties = requestDocument.getProperties().getMap("pi:task");
        String path = properties.getString("ecm:path");
        StringBuilder query = new StringBuilder();
        query.append("SELECT * FROM Document ");
        query.append("WHERE ecm:primaryType = 'TaskDoc' ");
        query.append("AND ecm:currentLifeCycleState = 'opened' ");
        query.append("AND ecm:path = '").append(path).append("' ");
        OperationRequest request = nuxeoSession.newRequest("Document.QueryES");
        request.set("X-NXDocumentProperties", (Object)"dublincore, task");
        request.set("query", (Object)query.toString());
        Documents documents = (Documents)request.execute();
        Document task = documents.size() == 1 ? documents.get(0) : null;
        return task;
    }

    public String getId() {
        return null;
    }
}

