/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.workspace.plugin.forms;

import fr.toutatice.portail.cms.nuxeo.api.NuxeoController;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilter;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterContext;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterException;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterExecutor;
import fr.toutatice.portail.cms.nuxeo.api.forms.FormFilterParameterType;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.osivia.directory.v2.model.ext.WorkspaceMember;
import org.osivia.directory.v2.service.WorkspaceService;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.directory.v2.DirServiceFactory;
import org.osivia.portal.api.locator.Locator;
import org.osivia.portal.api.notifications.INotificationsService;
import org.osivia.portal.api.notifications.NotificationsType;
import org.osivia.services.workspace.portlet.model.InvitationState;
import org.osivia.services.workspace.portlet.repository.MemberManagementRepository;
import org.osivia.services.workspace.util.ApplicationContextProvider;
import org.springframework.context.ApplicationContext;

public class AcceptWorkspaceInvitationCurrentLoginFormFilter
implements FormFilter {
    public static final String IDENTIFIER = "ACCEPT_WORKSPACE_INVITATION_CURRENT_LOGIN";
    private static final String LABEL_INTERNATIONALIZATION_KEY = "ACCEPT_WORKSPACE_INVITATION_CURRENT_LOGIN_FORM_FILTER_LABEL";
    private static final String DESCRIPTION_INTERNATIONALIZATION_KEY = null;
    private MemberManagementRepository repository;
    private final PortletContext portletContext;

    public AcceptWorkspaceInvitationCurrentLoginFormFilter(PortletContext portletContext) {
        this.portletContext = portletContext;
    }

    public String getId() {
        return IDENTIFIER;
    }

    public String getLabelKey() {
        return LABEL_INTERNATIONALIZATION_KEY;
    }

    public String getDescriptionKey() {
        return DESCRIPTION_INTERNATIONALIZATION_KEY;
    }

    public Map<String, FormFilterParameterType> getParameters() {
        return null;
    }

    public boolean hasChildren() {
        return false;
    }

    public void execute(FormFilterContext context, FormFilterExecutor executor) throws FormFilterException {
        PortalControllerContext portalControllerContext = context.getPortalControllerContext();
        HttpServletRequest servletRequest = portalControllerContext.getHttpServletRequest();
        HttpSession session = servletRequest.getSession();
        NuxeoController nuxeoController = new NuxeoController(this.portletContext);
        nuxeoController.setServletRequest(servletRequest);
        Map variables = context.getVariables();
        variables.put("uid", servletRequest.getRemoteUser());
        WorkspaceService service = (WorkspaceService)DirServiceFactory.getService(WorkspaceService.class);
        List allMembers = service.getAllMembers((String)variables.get("workspaceId"));
        boolean alreadyMember = false;
        for (WorkspaceMember member : allMembers) {
            if (!member.getMember().getUid().equals(servletRequest.getRemoteUser())) continue;
            alreadyMember = true;
            break;
        }
        if (alreadyMember) {
            String message = "Vous \u00eates d\u00e9j\u00e0 membre de cet espace.";
            INotificationsService notificationsService = (INotificationsService)Locator.findMBean(INotificationsService.class, (String)"osivia:service=NotificationsService");
            notificationsService.addSimpleNotification(portalControllerContext, message, NotificationsType.WARNING);
            variables.put("error", "1");
        } else {
            this.getRepository().acceptInvitation(nuxeoController, variables);
            variables.put("invitationState", InvitationState.ACCEPTED.toString());
            variables.put("acknowledgmentDate", String.valueOf(System.currentTimeMillis()));
            variables.put("error", "0");
            session.setAttribute("osivia.session.reload", (Object)true);
        }
    }

    private MemberManagementRepository getRepository() {
        if (this.repository == null) {
            ApplicationContext applicationContext = ApplicationContextProvider.getApplicationContext();
            this.repository = (MemberManagementRepository)applicationContext.getBean(MemberManagementRepository.class);
        }
        return this.repository;
    }
}

