/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.workspace.portlet.repository;

import fr.toutatice.portail.cms.nuxeo.api.INuxeoCommand;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilter;
import fr.toutatice.portail.cms.nuxeo.api.NuxeoQueryFilterContext;
import java.text.Normalizer;
import org.nuxeo.ecm.automation.client.OperationRequest;
import org.nuxeo.ecm.automation.client.Session;
import org.nuxeo.ecm.automation.client.model.Documents;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Component
@Scope(value="prototype")
public class SearchPersonsCommand
implements INuxeoCommand {
    private String filter;

    public SearchPersonsCommand(String filter) {
        filter = Normalizer.normalize(filter, Normalizer.Form.NFD);
        this.filter = filter = filter.replaceAll("[\\p{InCombiningDiacriticalMarks}]", "");
    }

    public Object execute(Session nuxeoSession) throws Exception {
        StringBuilder clause = new StringBuilder();
        clause.append("ecm:primaryType = 'UserProfile' ");
        clause.append("AND (ttc_userprofile:login ILIKE '%").append(this.filter);
        clause.append("%' OR dc:title ILIKE '%").append(this.filter);
        clause.append("%' OR ttc_userprofile:mail ILIKE '%").append(this.filter);
        clause.append("%' OR ttc_userprofile:mailaca ILIKE '%").append(this.filter);
        clause.append("%') ");
        clause.append(" AND ttc_userprofile:shownInSearch = true ");
        String filteredClause = NuxeoQueryFilter.addPublicationFilter((NuxeoQueryFilterContext)NuxeoQueryFilterContext.CONTEXT_LIVE, (String)clause.toString());
        OperationRequest request = nuxeoSession.newRequest("Document.QueryES");
        request.set("X-NXDocumentProperties", (Object)"*");
        request.set("query", (Object)("SELECT * FROM Document WHERE " + filteredClause));
        Documents results = (Documents)request.execute();
        return results;
    }

    public String getId() {
        return this.getClass().getSimpleName().concat("/").concat(this.filter);
    }
}

