/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.plugin.service;

import fr.gouv.education.foad.plugin.model.WorkspaceSearchResultsListTemplateModule;
import fr.gouv.education.foad.plugin.service.CustomizedMemberManagementPluginService;
import fr.toutatice.portail.cms.nuxeo.api.domain.ListTemplate;
import fr.toutatice.portail.cms.nuxeo.api.portlet.IPortletModule;
import fr.toutatice.portail.cms.nuxeo.api.workspace.WorkspaceType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.Name;
import javax.portlet.PortletRequest;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.customization.CustomizationContext;
import org.osivia.portal.api.directory.v2.model.Group;
import org.osivia.portal.api.directory.v2.service.GroupService;
import org.osivia.portal.api.directory.v2.service.PersonService;
import org.osivia.portal.api.internationalization.Bundle;
import org.osivia.portal.api.internationalization.IBundleFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class CustomizedMemberManagementPluginServiceImpl
implements CustomizedMemberManagementPluginService {
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private IBundleFactory bundleFactory;
    @Autowired
    private PersonService personService;
    @Autowired
    private GroupService groupService;

    public void customizeListTemplates(CustomizationContext customizationContext, Map<String, ListTemplate> listTemplates) {
        Bundle bundle = this.bundleFactory.getBundle(customizationContext.getLocale());
        ListTemplate workspaceSearchResults = new ListTemplate("workspace-search-results", bundle.getString("LIST_TEMPLATE_WORKSPACE_SEARCH_RESULTS"), "*");
        IPortletModule workspaceSearchResultsModule = (IPortletModule)this.applicationContext.getBean(WorkspaceSearchResultsListTemplateModule.class);
        workspaceSearchResults.setModule(workspaceSearchResultsModule);
        listTemplates.put(workspaceSearchResults.getKey(), workspaceSearchResults);
    }

    public String getFilter(PortalControllerContext portalControllerContext) {
        PortletRequest request = portalControllerContext.getRequest();
        StringBuilder builder = new StringBuilder();
        Boolean administrator = Boolean.TRUE.equals(request.getAttribute("osivia.isAdministrator"));
        if (!administrator.booleanValue()) {
            String user = request.getRemoteUser();
            Set values = this.getUserValues(user);
            builder.append("ecm:acl IN ('");
            builder.append(StringUtils.join((Collection)values, (String)"', '"));
            builder.append("') ");
            if (user != null) {
                builder.append("OR (ecm:primaryType = 'Workspace' ");
                builder.append("AND ttcs:spaceMembers/*/login <> '").append(user).append("' ");
                builder.append("AND ttcs:visibility = '").append(WorkspaceType.PRIVATE).append("')");
            }
        }
        return builder.toString();
    }

    private Set<String> getUserValues(String user) {
        HashSet<String> values;
        if (StringUtils.isEmpty((String)user)) {
            values = new HashSet<String>(1);
        } else {
            Name dn = this.personService.getEmptyPerson().buildDn(user);
            Group criteria = this.groupService.getEmptyGroup();
            criteria.setMembers(Arrays.asList(dn));
            List groups = this.groupService.search(criteria);
            values = new HashSet(groups.size() + 2);
            values.add(user);
            for (Group group : groups) {
                String cn = group.getCn();
                values.add(cn);
            }
        }
        values.add("Everyone");
        return values;
    }
}

