/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.workspace.portlet.controller;

import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.workspace.portlet.model.AbstractChangeRoleForm;
import org.osivia.services.workspace.portlet.model.MemberManagementOptions;
import org.osivia.services.workspace.portlet.model.MemberObject;
import org.osivia.services.workspace.portlet.model.validator.ChangeRoleFormValidator;
import org.osivia.services.workspace.portlet.service.MemberManagementService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.portlet.bind.PortletRequestDataBinder;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@SessionAttributes(value={"changeRoleForm"})
public abstract class AbstractMemberManagementChangeRoleController<M extends MemberObject, F extends AbstractChangeRoleForm<M>> {
    @Autowired
    private PortletContext portletContext;
    @Autowired
    private MemberManagementService service;
    @Autowired
    private ChangeRoleFormValidator validator;

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response, @RequestParam(value="tab") String tab) throws PortletException {
        request.setAttribute("tab", (Object)tab);
        request.setAttribute("view", (Object)"change-role");
        return "change-role/view";
    }

    @ActionMapping(value="redirectTab")
    public void redirectTab(ActionRequest request, ActionResponse response, @RequestParam(value="redirection") String redirection, SessionStatus sessionStatus) throws PortletException {
        sessionStatus.setComplete();
        response.setRenderParameter("tab", redirection);
    }

    @ActionMapping(value="save")
    public void save(ActionRequest request, ActionResponse response, @RequestParam(value="tab") String tab, @ModelAttribute(value="options") MemberManagementOptions options, @Validated @ModelAttribute(value="changeRoleForm") F form, BindingResult result, SessionStatus sessionStatus) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        response.setRenderParameter("tab", tab);
        if (result.hasErrors()) {
            response.setRenderParameter("view", "change-role");
        } else {
            this.service.updateRole(portalControllerContext, options, form);
            sessionStatus.setComplete();
        }
    }

    @ModelAttribute(value="changeRoleForm")
    public F getForm(PortletRequest request, PortletResponse response, @RequestParam(name="identifiers", required=false) String[] identifiers) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return (F)this.service.getChangeRoleForm(portalControllerContext, identifiers, this.getMemberType(), this.getFormType());
    }

    @InitBinder(value={"changeRoleForm"})
    public void formInitBinder(PortletRequestDataBinder binder) {
        binder.addValidators(new Validator[]{this.validator});
    }

    @ModelAttribute(value="options")
    public MemberManagementOptions getOptions(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getOptions(portalControllerContext);
    }

    public abstract Class<M> getMemberType();

    public abstract Class<F> getFormType();
}

