/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.services.workspace.portlet.controller;

import java.beans.PropertyEditor;
import java.text.ParseException;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletContext;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;
import org.osivia.directory.v2.model.CollabProfile;
import org.osivia.portal.api.PortalException;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.services.workspace.portlet.model.ImportForm;
import org.osivia.services.workspace.portlet.model.MemberManagementOptions;
import org.osivia.services.workspace.portlet.model.converter.LocalGroupPropertyEditor;
import org.osivia.services.workspace.portlet.model.validator.ImportValidator;
import org.osivia.services.workspace.portlet.service.MemberManagementService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Validator;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.portlet.bind.PortletRequestDataBinder;
import org.springframework.web.portlet.bind.annotation.ActionMapping;
import org.springframework.web.portlet.bind.annotation.RenderMapping;

@Controller
@RequestMapping(path={"VIEW"}, params={"tab=importCsv"})
@SessionAttributes(value={"import"})
public class MemberManagementImportController {
    @Autowired
    private PortletContext portletContext;
    @Autowired
    private MemberManagementService service;
    @Autowired
    private LocalGroupPropertyEditor localGroupPropertyEditor;
    @Autowired
    private ImportValidator validator;

    @RenderMapping
    public String view(RenderRequest request, RenderResponse response) throws PortletException {
        request.setAttribute("tab", (Object)"importCsv");
        return "importcsv/view";
    }

    @ModelAttribute(value="import")
    public ImportForm getInvitationsForm(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getImportForm(portalControllerContext);
    }

    @ModelAttribute(value="options")
    public MemberManagementOptions getOptions(PortletRequest request, PortletResponse response) throws PortletException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, request, response);
        return this.service.getOptions(portalControllerContext);
    }

    @ActionMapping(value="launchImport")
    public void launchImport(ActionRequest request, ActionResponse response, @ModelAttribute(value="options") MemberManagementOptions options, @Validated @ModelAttribute(value="import") ImportForm form, BindingResult result, SessionStatus sessionStatus) throws PortletException, ParseException, PortalException {
        PortalControllerContext portalControllerContext = new PortalControllerContext(this.portletContext, (PortletRequest)request, (PortletResponse)response);
        if (!result.hasErrors()) {
            this.service.prepareImportInvitations(portalControllerContext, options, form);
            response.setRenderParameter("tab", "members");
            sessionStatus.setComplete();
        } else {
            response.setRenderParameter("tab", "importCsv");
        }
    }

    @InitBinder(value={"import"})
    public void importFormInitBinder(PortletRequestDataBinder binder) {
        binder.addValidators(new Validator[]{this.validator});
        binder.registerCustomEditor(CollabProfile.class, (PropertyEditor)this.localGroupPropertyEditor);
    }
}

