/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.userworkspaces;

import fr.gouv.education.foad.userworkspaces.TribuUserWorkspacesServiceImpl;
import fr.toutatice.ecm.platform.collab.tools.userprofile.TtcUserProfileServiceImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.elasticsearch.api.ElasticSearchService;
import org.nuxeo.elasticsearch.query.NxQueryBuilder;
import org.nuxeo.runtime.api.Framework;

public class TribuUserProfileServiceImpl
extends TtcUserProfileServiceImpl {
    private static final Log uLog = LogFactory.getLog((String)"userprofiles");

    public void asyncCreateUserProfile(CoreSession session, String username) {
        if (this.controls(session, username)) {
            DocumentModel userProfile = super.getUserProfileDocument(username, session);
            if (userProfile == null) {
                UserWorkspaceService service = (UserWorkspaceService)Framework.getService(UserWorkspaceService.class);
                if (service instanceof TribuUserWorkspacesServiceImpl) {
                    TribuUserWorkspacesServiceImpl tuw = (TribuUserWorkspacesServiceImpl)service;
                    tuw.asyncCreateUserWorkspace(session, username);
                }
                DocumentModel documentModel = this.getOrCreateUserProfileDocument(username, session);
                uLog.info((Object)("Cr\u00e9ation profil pour " + username + ", chemin:" + documentModel.getPathAsString()));
            } else {
                uLog.info((Object)("Profil existant pour " + username + ", chemin:" + userProfile.getPathAsString()));
            }
        }
    }

    private boolean controls(CoreSession session, String userName) {
        boolean ret = true;
        ElasticSearchService service = (ElasticSearchService)Framework.getService(ElasticSearchService.class);
        NxQueryBuilder queryBuilder = new NxQueryBuilder(session);
        queryBuilder.nxql("SELECT * FROM UserProfile WHERE ttc_userprofile:login = '" + userName + "' AND ecm:isProxy = 0  AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState != 'deleted'");
        DocumentModelList esResponse = service.query(queryBuilder);
        if (esResponse.size() == 0) {
            DocumentModelList vcsResponse = session.query("SELECT * FROM UserProfile WHERE ecm:acl/*1/principal = '" + userName + "' AND ecm:isProxy = 0  AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState != 'deleted'");
            if (vcsResponse.size() == 1) {
                uLog.warn((Object)("Err1 - Profil non index\u00e9 pour " + userName + ", chemin:" + ((DocumentModel)vcsResponse.get(0)).getPathAsString()));
                ret = false;
            } else if (vcsResponse.size() > 1) {
                uLog.warn((Object)("Err2 - Plusieurs profils non index\u00e9s pour " + userName + ", chemin:" + ((DocumentModel)vcsResponse.get(0)).getPathAsString()));
                ret = false;
            }
        } else if (esResponse.size() > 1) {
            uLog.warn((Object)("Err3 - Plusieurs profils dans l'index pour " + userName + ", nb:" + esResponse.size()));
            ret = false;
        }
        return ret;
    }
}

