/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.userworkspaces;

import fr.gouv.education.foad.userworkspaces.TribuUserProfileServiceImpl;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.user.center.profile.UserProfileService;
import org.nuxeo.runtime.api.Framework;

public class UserProfileCreationWork
extends AbstractWork {
    public static final String UWS_CATEGORY = "USERPROFILE_CREATION";
    public static final String UWS_QUEUE_ID = "userprofile-creation-queue";
    private static final Log uLog = LogFactory.getLog((String)"userprofiles");
    private static final long serialVersionUID = -9034677557639603196L;
    private final String username;

    public UserProfileCreationWork(String username) {
        super("USERPROFILE_CREATION/" + username);
        this.username = username;
    }

    public void work() throws Exception {
        this.initSession();
        UserProfileService service = (UserProfileService)Framework.getService(UserProfileService.class);
        if (!(service instanceof TribuUserProfileServiceImpl)) {
            throw new UnsupportedOperationException("Service TribuUserWorkspacesServiceImpl introuvable");
        }
        TribuUserProfileServiceImpl upService = (TribuUserProfileServiceImpl)service;
        upService.asyncCreateUserProfile(this.session, this.username);
        Date now = new Date();
        long elasped = now.getTime() - this.getStartTime();
        long scheduled = now.getTime() - this.getSchedulingTime();
        WorkManager workManager = (WorkManager)Framework.getLocalService(WorkManager.class);
        int queueSize = workManager.getQueueSize(UWS_QUEUE_ID, null) - 1;
        uLog.info((Object)("Fin traitement pour " + this.getTitle() + ", temps d'attente " + scheduled + "ms, temps d'ex\u00e9cution : " + elasped + "ms, taille file d'attente : " + queueSize));
    }

    public String getCategory() {
        return UWS_CATEGORY;
    }

    public String getTitle() {
        return this.getId();
    }
}

