/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.education.foad.selector.type.portlet.service;

import fr.gouv.education.foad.selector.type.portlet.model.SearchType;
import fr.gouv.education.foad.selector.type.portlet.model.TypeSelectorForm;
import fr.gouv.education.foad.selector.type.portlet.model.TypeSelectorSettings;
import fr.gouv.education.foad.selector.type.portlet.service.TypeSelectorService;
import fr.toutatice.portail.cms.nuxeo.api.PageSelectors;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.portlet.ActionResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.osivia.portal.api.context.PortalControllerContext;
import org.osivia.portal.api.windows.PortalWindow;
import org.osivia.portal.api.windows.WindowFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;

@Service
public class TypeSelectorServiceImpl
implements TypeSelectorService {
    @Autowired
    private ApplicationContext applicationContext;

    public TypeSelectorSettings getSettings(PortalControllerContext portalControllerContext) throws PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        TypeSelectorSettings settings = (TypeSelectorSettings)this.applicationContext.getBean(TypeSelectorSettings.class);
        String label = window.getProperty("foad.type-selector.label");
        settings.setLabel(label);
        settings.setSelectorId("type");
        return settings;
    }

    public void save(PortalControllerContext portalControllerContext, TypeSelectorSettings settings) throws PortletException {
        PortalWindow window = WindowFactory.getWindow((PortletRequest)portalControllerContext.getRequest());
        String label = StringUtils.trimToNull((String)settings.getLabel());
        window.setProperty("foad.type-selector.label", label);
    }

    public TypeSelectorForm getForm(PortalControllerContext portalControllerContext) throws PortletException {
        boolean empty;
        PortletRequest request = portalControllerContext.getRequest();
        TypeSelectorSettings settings = this.getSettings(portalControllerContext);
        Map selectors = PageSelectors.decodeProperties((String)request.getParameter("selectors"));
        List selectorValues = (List)selectors.get("type");
        if (CollectionUtils.isEmpty((Collection)selectorValues)) {
            empty = true;
        } else {
            String selectorValue = (String)selectorValues.get(0);
            empty = StringUtils.isEmpty((String)selectorValue);
        }
        TypeSelectorForm form = (TypeSelectorForm)this.applicationContext.getBean(TypeSelectorForm.class);
        String label = settings.getLabel();
        form.setLabel(label);
        SearchType type = empty ? SearchType.ALL : SearchType.WORKSPACE;
        form.setType(type);
        List<SearchType> types = Arrays.asList(SearchType.values());
        form.setTypes(types);
        return form;
    }

    public void select(PortalControllerContext portalControllerContext, TypeSelectorForm form) throws PortletException {
        PortletRequest request = portalControllerContext.getRequest();
        ActionResponse response = (ActionResponse)portalControllerContext.getResponse();
        TypeSelectorSettings settings = this.getSettings(portalControllerContext);
        String selectorId = settings.getSelectorId();
        if (StringUtils.isNotEmpty((String)selectorId)) {
            Map selectors = PageSelectors.decodeProperties((String)request.getParameter("selectors"));
            SearchType type = form.getType();
            if (SearchType.ALL.equals((Object)type)) {
                selectors.remove(selectorId);
            } else {
                selectors.put(selectorId, Arrays.asList(type.getDocType()));
            }
            response.setRenderParameter("selectors", PageSelectors.encodeProperties((Map)selectors));
        }
    }
}

