/*
 * Decompiled with CFR 0.152.
 */
package fr.index.cloud.ens.metadata;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.collectors.DocumentModelCollector;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;

@Operation(id="Index.UpdateMetadata", category="Document", label="Update Index Cloud meta data in silent mode", description="Create an entry in the \"rshr:targets complex property value on the input document. The document is automatically saved if 'save' parameter is true. If you unset the 'save' you need to save it later using Save Document operation. Return the modified document.")
public class UpdateMetadata {
    public static final String ID = "Index.UpdateMetadata";
    private static final String TARGET_XPATH = "rshr:targets";
    @Context
    protected CoreSession session;
    @Param(name="properties", required=false)
    protected Properties properties = null;
    @Param(name="targetValue", required=false)
    protected Properties targetValue = null;
    @Param(name="targetIndex", required=false)
    protected String targetIndex = null;
    @Param(name="targetAction", required=false)
    protected String targetAction = null;
    @Param(name="removeFormat", required=false)
    protected boolean removeFormat = false;
    @Param(name="save", required=false, values={"true"})
    protected boolean save = true;

    @OperationMethod(collector=DocumentModelCollector.class)
    public DocumentModel run(DocumentModel doc) throws Exception {
        DocumentModel updatedDoc = this.execute(this.session, doc, this.properties, this.targetAction, this.targetIndex, this.targetValue, this.save);
        return updatedDoc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected DocumentModel execute(CoreSession session, DocumentModel document, Properties properties, String targetAction, String targetIndex, Properties targetValue, boolean save) throws ClientException, IOException, DocumentException {
        if (!document.isCheckedOut()) {
            document.checkOut();
        }
        if (properties != null) {
            DocumentHelper.setProperties((CoreSession)session, (DocumentModel)document, (Properties)properties);
        }
        if (this.removeFormat) {
            DocumentHelper.removeProperty((DocumentModel)document, (String)"rshr:format");
        }
        if ("publish".equals(targetAction)) {
            Property property = document.getProperty(TARGET_XPATH);
            if (property == null) throw new DocumentException("no property with name " + property);
            Serializable value2 = property.getValue();
            if (!(value2 instanceof Serializable) || !(value2 instanceof List)) throw new DocumentException("the value is not a Serializable List " + targetValue);
            List complexList = (List)((Object)value2);
            HashMap targetMap = new HashMap(targetValue);
            String pubGroups = (String)targetValue.get((Object)"pubGroups");
            if (pubGroups != null) {
                ArrayList<String> normalizedPubGroups = new ArrayList<String>();
                String[] toks = pubGroups.split(",");
                for (int i = 0; i < toks.length; ++i) {
                    normalizedPubGroups.add(toks[i]);
                }
                targetMap.put("pubGroups", normalizedPubGroups);
            }
            complexList.add(targetMap);
            document.setPropertyValue(TARGET_XPATH, (Serializable)((Object)complexList));
        }
        if ("unpublish".equals(targetAction)) {
            DocumentHelper.removeProperty((DocumentModel)document, (String)("rshr:targets/" + targetIndex));
        }
        if (!save) return document;
        ToutaticeDocumentHelper.saveDocumentSilently((CoreSession)session, (DocumentModel)document, (boolean)false);
        return document;
    }
}

