/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.demo.userworkspaces;

import fr.toutatice.ecm.platform.core.userworkspace.ToutaticeUserWorkspaceServiceImpl;
import java.io.Serializable;
import java.security.Principal;
import org.apache.commons.lang.Validate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.Path;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.impl.ACLImpl;
import org.nuxeo.ecm.core.api.security.impl.ACPImpl;

public class UserWorkspaceService
extends ToutaticeUserWorkspaceServiceImpl {
    private static final long serialVersionUID = 6465767707468908495L;
    private static final String TTC_TEMPLATE = "ttc:pageTemplate";
    private static final String TTC_SHOW_IN_MENU = "ttc:showInMenu";
    private static final String TTC_WEBID = "ttc:webid";
    private static final String DC_TITLE = "dc:title";
    private static final Log log = LogFactory.getLog(UserWorkspaceService.class);
    protected static final int UW_PREFIX_SEGMENT_SIZE = 3;

    protected void setFoldersACL(DocumentModel doc, String userName) throws ClientException {
        ACPImpl acp = new ACPImpl();
        ACE grantMembersRead = new ACE("Everyone", "Read", true);
        ACE grantEverything = new ACE(userName, "Everything", true);
        ACLImpl acl = new ACLImpl();
        acl.setACEs(new ACE[]{grantMembersRead, grantEverything});
        acp.addACL((ACL)acl);
        doc.setACP((ACP)acp, true);
    }

    protected PathRef resolveUserWorkspace(CoreSession session, PathRef homeDomainRef, String username, String workspacename, int maxsize) {
        PathRef usWsRef = null;
        String usWsName = super.getUserWorkspaceNameForUser(username);
        Path usWsPath = this.computeUserWorspacePath(homeDomainRef.toString(), usWsName);
        usWsRef = new PathRef(usWsPath.toString());
        return usWsRef;
    }

    protected Path computeUserWorspacePath(String rootPath, String usWsName) {
        Path usWsPath = new Path("/" + rootPath);
        for (int i = 0; i < usWsName.length() && i < 3; ++i) {
            usWsPath = usWsPath.append(usWsName.charAt(i) + "/");
        }
        usWsPath = usWsPath.append(usWsName);
        return usWsPath;
    }

    protected DocumentModel doCreateUserWorkspace(CoreSession unrestrictedSession, PathRef userWSRef, Principal principal, String userName) throws ClientException {
        DocumentModel uw = null;
        Path uwsPath = new Path(userWSRef.toString());
        for (int i = 2; i < uwsPath.segmentCount(); ++i) {
            PathRef nodeRef;
            if (log.isDebugEnabled()) {
                log.debug((Object)("    - Cr\u00e9ation du document " + uwsPath.uptoSegment(i).toString()));
            }
            if (unrestrictedSession.exists((DocumentRef)(nodeRef = new PathRef(uwsPath.uptoSegment(i).toString())))) continue;
            DocumentModel node = this.createUserWorkspacesRootSegment(unrestrictedSession, nodeRef);
            Validate.isTrue((boolean)node.getPathAsString().equals(nodeRef.toString()));
        }
        if (!unrestrictedSession.exists((DocumentRef)userWSRef)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(" -- Cr\u00e9ation du userWorkspace du user [" + userName + "] : " + userWSRef.value));
            }
            uw = super.doCreateUserWorkspace(unrestrictedSession, userWSRef, principal, userName);
        }
        uw.setProperty("toutatice", "tabOrder", (Object)"100");
        uw.setPropertyValue(DC_TITLE, (Serializable)((Object)"Mon espace"));
        uw = unrestrictedSession.saveDocument(uw);
        String workspaceId = null;
        Serializable propertyValue = uw.getPropertyValue("webc:url");
        if (propertyValue != null) {
            workspaceId = propertyValue.toString();
        }
        DocumentModel mesDocs = unrestrictedSession.createDocumentModel(uw.getPathAsString(), "documents", "Folder");
        mesDocs.setPropertyValue(DC_TITLE, (Serializable)((Object)"Documents"));
        mesDocs.setPropertyValue(TTC_SHOW_IN_MENU, (Serializable)Boolean.TRUE);
        unrestrictedSession.createDocument(mesDocs);
        if (workspaceId != null) {
            DocumentModel searchStaple = unrestrictedSession.createDocumentModel(uw.getPathAsString(), "search-staple", "Staple");
            searchStaple.setPropertyValue(DC_TITLE, (Serializable)((Object)"Recherche"));
            searchStaple.setPropertyValue(TTC_SHOW_IN_MENU, (Serializable)Boolean.TRUE);
            searchStaple.setPropertyValue(TTC_TEMPLATE, (Serializable)((Object)"/default/templates/workspace/search"));
            searchStaple.setPropertyValue(TTC_WEBID, (Serializable)((Object)("workspace_" + workspaceId + "_search")));
            unrestrictedSession.createDocument(searchStaple);
        }
        return uw;
    }

    protected DocumentModel createUserWorkspacesRootSegment(CoreSession unrestrictedSession, PathRef rootRef) throws ClientException {
        String parentPath = new Path(rootRef.toString()).removeLastSegments(1).toString();
        String docName = new Path(rootRef.toString()).lastSegment();
        DocumentModel doc = unrestrictedSession.createDocumentModel(parentPath, docName, this.getUserWorkspaceRootType());
        doc.setProperty("dublincore", "title", (Object)docName);
        doc.setProperty("dublincore", "description", (Object)"");
        doc = unrestrictedSession.createDocument(doc);
        super.setUserWorkspaceRootACL(doc);
        return doc;
    }
}

