/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.fs;

import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.monitor.fs.FsProbe;
import org.elasticsearch.monitor.fs.FsStats;

public class FsService
extends AbstractComponent {
    private final FsProbe probe;
    private final TimeValue refreshInterval;
    private FsStats cachedStats;

    @Inject
    public FsService(Settings settings, FsProbe probe) {
        super(settings);
        this.probe = probe;
        this.cachedStats = probe.stats();
        this.refreshInterval = this.componentSettings.getAsTime("refresh_interval", TimeValue.timeValueSeconds(1L));
        this.logger.debug("Using probe [{}] with refresh_interval [{}]", probe, this.refreshInterval);
    }

    public synchronized FsStats stats() {
        if (System.currentTimeMillis() - this.cachedStats.getTimestamp() > this.refreshInterval.millis()) {
            this.cachedStats = this.probe.stats();
        }
        return this.cachedStats;
    }
}

