/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.interactive.form;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDCheckbox;
import org.apache.pdfbox.pdmodel.interactive.form.PDChoiceButton;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDFieldFactory;
import org.apache.pdfbox.util.BitFlagHelper;

public class PDRadioCollection
extends PDChoiceButton {
    public static final int FLAG_RADIOS_IN_UNISON = 0x2000000;

    public PDRadioCollection(PDAcroForm theAcroForm, COSDictionary field) {
        super(theAcroForm, field);
    }

    public void setRadiosInUnison(boolean radiosInUnison) {
        BitFlagHelper.setFlag(this.getDictionary(), COSName.FF, 0x2000000, radiosInUnison);
    }

    public boolean isRadiosInUnison() {
        return BitFlagHelper.getFlag(this.getDictionary(), COSName.FF, 0x2000000);
    }

    public void setValue(String value) throws IOException {
        this.getDictionary().setString(COSName.V, value);
        List kids = this.getKids();
        for (int i = 0; i < kids.size(); ++i) {
            PDField field = (PDField)kids.get(i);
            if (!(field instanceof PDCheckbox)) continue;
            PDCheckbox btn = (PDCheckbox)field;
            if (btn.getOnValue().equals(value)) {
                btn.check();
                continue;
            }
            btn.unCheck();
        }
    }

    public String getValue() throws IOException {
        String retval = null;
        List kids = this.getKids();
        for (int i = 0; i < kids.size(); ++i) {
            PDCheckbox btn;
            PDField kid = (PDField)kids.get(i);
            if (!(kid instanceof PDCheckbox) || !(btn = (PDCheckbox)kid).isChecked()) continue;
            retval = btn.getOnValue();
        }
        if (retval == null) {
            retval = this.getDictionary().getNameAsString(COSName.V);
        }
        return retval;
    }

    public List getKids() throws IOException {
        COSArray kids = (COSArray)this.getDictionary().getDictionaryObject(COSName.KIDS);
        if (kids != null) {
            ArrayList<PDField> kidsList = new ArrayList<PDField>();
            for (int i = 0; i < kids.size(); ++i) {
                PDField field = PDFieldFactory.createField(this.getAcroForm(), (COSDictionary)kids.getObject(i));
                if (field == null) continue;
                kidsList.add(field);
            }
            return new COSArrayList(kidsList, kids);
        }
        return new ArrayList();
    }
}

