/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.jaxrs.servlet.mapping;

import org.nuxeo.ecm.webengine.jaxrs.servlet.mapping.Path;

public class PathParser {
    protected String[] array;
    protected int count;
    protected char[] buf;
    protected int bufCount;

    public PathParser() {
        this.reset();
    }

    public void reset() {
        this.array = new String[16];
        this.buf = new char[16];
        this.count = 0;
        this.bufCount = 0;
    }

    public Path parse(String path) {
        return this.parse(path, -1);
    }

    public Path parse(String path, int userBits) {
        char[] chars = path.toCharArray();
        if (chars.length == 0) {
            return Path.EMPTY;
        }
        if (chars.length == 1 && chars[0] == '/') {
            return Path.ROOT;
        }
        int i = 0;
        int len = chars.length;
        int bits = 0;
        if (chars[chars.length - 1] == '/') {
            bits |= 2;
            --len;
        }
        if (chars[0] == '/') {
            bits |= 1;
            ++i;
        }
        while (i < len) {
            char c = chars[i];
            if (c == '/') {
                if (this.hasSegment()) {
                    this.addSegment(this.currentSegment());
                    this.resetBuf();
                }
            } else {
                this.append(c);
            }
            ++i;
        }
        if (this.hasSegment()) {
            this.addSegment(this.currentSegment());
        }
        return new Path(this.getSegments(), userBits == -1 ? bits : userBits);
    }

    public void back() {
        if (this.count == 0) {
            this.add("..");
        } else {
            --this.count;
        }
    }

    public void addSegment(String segment) {
        if ("..".equals(segment)) {
            this.back();
        } else if (!".".equals(segment)) {
            this.add(segment);
        }
    }

    public String[] getSegments() {
        String[] result = new String[this.count];
        System.arraycopy(this.array, 0, result, 0, this.count);
        return result;
    }

    private final void add(String segment) {
        if (this.count + 1 == this.array.length) {
            String[] result = new String[this.count + 16];
            System.arraycopy(this.array, 0, result, 0, this.count);
            this.array = result;
        }
        this.array[this.count++] = segment;
    }

    private final void append(char c) {
        if (this.bufCount + 1 == this.buf.length) {
            char[] result = new char[this.bufCount + 16];
            System.arraycopy(this.buf, 0, result, 0, this.bufCount);
            this.buf = result;
        }
        this.buf[this.bufCount++] = c;
    }

    private final String currentSegment() {
        return new String(this.buf, 0, this.bufCount);
    }

    private final boolean hasSegment() {
        return this.bufCount > 0;
    }

    private final void resetBuf() {
        this.bufCount = 0;
    }
}

