/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.kerberos.shared.messages.value;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TransitedEncodingType
implements Comparable<TransitedEncodingType> {
    public static final TransitedEncodingType NULL = new TransitedEncodingType(0, "null");
    public static final TransitedEncodingType DOMAIN_X500_COMPRESS = new TransitedEncodingType(1, "Domain X500 compress");
    private static final TransitedEncodingType[] values = new TransitedEncodingType[]{NULL, DOMAIN_X500_COMPRESS};
    public static final List<TransitedEncodingType> VALUES = Collections.unmodifiableList(Arrays.asList(values));
    private final String name;
    private final int ordinal;

    private TransitedEncodingType(int ordinal, String name) {
        this.ordinal = ordinal;
        this.name = name;
    }

    public static TransitedEncodingType getTypeByOrdinal(int type) {
        for (int ii = 0; ii < values.length; ++ii) {
            if (TransitedEncodingType.values[ii].ordinal != type) continue;
            return values[ii];
        }
        return NULL;
    }

    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public int compareTo(TransitedEncodingType that) {
        return this.ordinal - that.ordinal;
    }

    public String toString() {
        return this.name + " (" + this.ordinal + ")";
    }
}

